#ifndef _ICOLVWD_
  #define _ICOLVWD_
/*******************************************************************************
* FILE NAME: icolvwd.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionViewData                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include  <icolobsv.hpp>
#include  <istrgen.hpp>

template <class Element, class ViewClass, class Collection > class IVBContainerControlData;
template <class Element,  class Collection > class ICollectionViewListBoxData;
template <class Element,  class Collection > class ICollectionViewComboBoxData;


template <class Element, class ViewClass, class Collection>
  class ICollectionViewData : public IBase {

private:

  ICollectionViewData( const IStringGenerator<Element>& stringGenerator )
  : fCollectionObserver( ICollectionObserver<Element,ViewClass,Collection>( ) ),
    fGenerator( stringGenerator )
  { }

  ICollectionViewData( )
  : fCollectionObserver( ICollectionObserver<Element,ViewClass,Collection>( ) )
  { }

 ~ICollectionViewData ( ) { }

  ICollectionViewData ( const ICollectionViewData<Element,ViewClass,Collection>& source );

ICollectionViewData<Element,ViewClass,Collection>
 &operator=           ( const ICollectionViewData<Element,ViewClass,Collection>& source );



ICollectionObserver< Element, ViewClass, Collection >
  fCollectionObserver;

IStringGenerator<Element>
  fGenerator;

friend ICollectionViewListBoxData < Element, Collection >;
friend ICollectionViewComboBoxData< Element, Collection >;
friend IVBContainerControlData    < Element, ViewClass, Collection >;

friend ViewClass;

};

#endif   /*  _ICOLVWD_  */
