#ifndef _ICOMBOBX_
  #define _ICOMBOBX_
/*******************************************************************************
* FILE NAME: icombobx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IComboBox                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icombobs.hpp>
#include <ientryfd.hpp>
#include <irect.hpp>

class IComboBoxData;

#pragma pack(4)

class IComboBox : public IBaseComboBox {
typedef IBaseComboBox
  Inherited;

public:

typedef IBaseComboBox::Cursor
  Cursor;

class Style;
/*------------------------------- Constructors -------------------------------*/
  IComboBox         ( unsigned long        id,
                      IWindow*             parent,
                      IWindow*             owner,
                      const IRectangle&    initial = IRectangle  ( ),
                      const Style&         style   = defaultStyle( ) );

  IComboBox         ( unsigned long        id,
                      IWindow*             parent );

  IComboBox         ( const IWindowHandle& handle);

virtual
 ~IComboBox         ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IComboBox, IWindow, IControl, IBaseComboBox);

static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&       style );

/*------------------------- Add Items ----------------------------------------*/
virtual unsigned long
  add               ( unsigned long      index,
                      const char*        text ),
  add               ( unsigned long      index,
                      const char* const* itemList,
                      unsigned long      count = 1 ),
  addAsFirst        ( const char*        text ),
  addAsLast         ( const char*        text ),
  addAscending      ( const char*        text ),
  addDescending     ( const char*        text ),
  add               ( unsigned long      index,
                      const IResourceId& item ),
  addAsFirst        ( const IResourceId& item ),
  addAsLast         ( const IResourceId& item ),
  addAscending      ( const IResourceId& item ),
  addDescending     ( const IResourceId& item );

virtual IComboBox
 &add               ( const char*        text,
                      Cursor&            cursor ),
 &add               ( const IResourceId& item,
                      Cursor&            cursor ),
 &addAsFirst        ( const char*        text,
                      Cursor&            cursor ),
 &addAsLast         ( const char*        text,
                      Cursor&            cursor ),
 &addAsNext         ( const char*        text,
                      Cursor&            cursor ),
 &addAsFirst        ( const IResourceId& item,
                      Cursor&            cursor),
 &addAsLast         ( const IResourceId& item,
                      Cursor&            cursor ),
 &addAsNext         ( const IResourceId& item,
                      Cursor&            cursor );

/*------------------------- Remove and Replace Items -------------------------*/
virtual IComboBox
 &removeAt          ( Cursor&            cursor ),
 &removeAll         ( ),
 &replaceAt         ( const char*        text,
                      const Cursor&      cursor ),
 &replaceAt         ( const IResourceId& item,
                      const Cursor&      cursor );

virtual unsigned long
  remove            ( unsigned long      index );

/*--------------------------- Notification Members ---------------------------*/
static INotificationId const
  IC_IMPORTU addId,
  IC_IMPORTU removeId;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IComboBox         ( const IComboBox&   comboBox );
IComboBox
 &operator=         ( const IComboBox&   comboBox );

/*--------------------------------- Private ----------------------------------*/
friend class IBaseComboBox::Cursor;

static Style
  currentDefaultStyle;

IComboBoxData
 *fComboBoxData;

};  /* IComboBox */

INESTEDBITFLAGCLASSFUNCS(Style, IComboBox);

#pragma pack()

#endif  /* _ICOMBOBX_ */
