/*******************************************************************************
* FILE NAME: icombovw.c                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icombovw.hpp                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#define IC_USE_CB

#include  <icollvwi.hpp>
#include  <icombovw.hpp>
#include  <icolvwd.hpp>
#include  <iseq.h>
#include  <ipartccl.h>


template <class Element, class Collection>
  const unsigned long
    ICollectionViewComboBox<Element, Collection>::noSelection = 0;


template <class Element, class Collection>
  class ICollectionViewComboBoxData : public IBase {

public:

  ICollectionViewComboBoxData( const IStringGenerator<Element>&
                                  stringGenerator );

 ~ICollectionViewComboBoxData ( );

ICollectionViewData< Element,
                     ICollectionViewComboBox< Element, Collection >,
                     Collection >
  *fCollectionViewData;

Boolean
  saveSelectionState;

private:
/*------------------------- Hidden Members -----------------------------------*/
  ICollectionViewComboBoxData
             ( const ICollectionViewComboBoxData< Element, Collection >& source );
ICollectionViewComboBoxData<Element,Collection>
 &operator=  ( const ICollectionViewComboBoxData< Element, Collection >& source );

};

template <class Element, class Collection>
  ICollectionViewComboBoxData<Element, Collection>::
    ICollectionViewComboBoxData( const IStringGenerator<Element>& stringGenerator )
      : saveSelectionState( false )
{
  fCollectionViewData = new
     ICollectionViewData< Element,
                          ICollectionViewComboBox< Element, Collection >,
                          Collection > ( stringGenerator);
}

template <class Element, class Collection>
  ICollectionViewComboBoxData<Element,Collection>::
   ~ICollectionViewComboBoxData ( )
{
  delete fCollectionViewData;
}

template <class Element, class Collection>
  ICollectionViewComboBox<Element,Collection>::
    ICollectionViewComboBox ( unsigned long                    identifier,
                              IWindow*                         parent,
                              IWindow*                         owner ,
                              const IRectangle&                initial,
                              const IBaseComboBox::Style&      style,
                              const IStringGenerator<Element>& stringGenerator )
    : IBaseComboBox( identifier, parent, owner, initial, style )
{
  fCollectionViewComboBoxData = new ICollectionViewComboBoxData<Element, Collection>( stringGenerator );
  fCollectionViewComboBoxData->fCollectionViewData->fCollectionObserver.setViewer( this );
  enableNotification();
}


template <class Element, class Collection>
  ICollectionViewComboBox<Element,Collection>::
    ICollectionViewComboBox( unsigned long                    identifier,
                             IWindow*                         parent,
                             const IStringGenerator<Element>& stringGenerator )
    : IBaseComboBox( identifier, parent )
{
  fCollectionViewComboBoxData = new ICollectionViewComboBoxData<Element, Collection>( stringGenerator );
  fCollectionViewComboBoxData->fCollectionViewData->fCollectionObserver.setViewer( this );
  enableNotification();
}

template <class Element, class Collection>
  ICollectionViewComboBox<Element,Collection>::
    ICollectionViewComboBox( const IWindowHandle&             handle,
                             const IStringGenerator<Element>& stringGenerator )
    : IBaseComboBox( handle )
{
  fCollectionViewComboBoxData =
     new ICollectionViewComboBoxData<Element, Collection>( stringGenerator );
  fCollectionViewComboBoxData->fCollectionViewData->fCollectionObserver.setViewer( this );
  enableNotification();
}

template <class Element, class Collection>
  ICollectionViewComboBox<Element,Collection>::
   ~ICollectionViewComboBox ( )
{
  disableNotification();

  delete fCollectionViewComboBoxData;
}


template <class Element, class Collection>
  INotificationId const ICollectionViewComboBox<Element,Collection>::itemChangedId =
    "ICollectionViewComboBox::itemChangedId";
template <class Element, class Collection>
  INotificationId const ICollectionViewComboBox<Element,Collection>::itemsId =
    "ICollectionViewComboBox::itemsId";


#include <ilistcv2.c>
