/*******************************************************************************
* FILE NAME: icompnen.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IComponent                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifndef _ICOMPNEN_
#define _ICOMPNEN_

#include <ipoint.hpp>
#include <istdntfy.hpp>
#include <istring.hpp>

// Forward References
class IModel;
class IGUIBundle;
class IDocumentStorage;
class IComponentImp;
class IUnknown; // SMY0221

// classes defined in this module
class IComponent;

#pragma pack(4)


/*******************************************************************************
*                                                                              *
*                           IComponent                                         *
*                                                                              *
*******************************************************************************/

class IComponent : public IVBase
{
public:

/*----------------------- Construction/Destruction ---------------------------*/

                            IComponent();
    virtual void            initialize(IGUIBundle& bundle, IModel* adoptedModel);
    virtual                 ~IComponent();
    

/*----------------------------- Adopt/orphan ---------------------------------*/

    virtual void            adoptModel(IModel*);
    virtual IModel*         orphanModel();

    
/*----------------------------- Informational --------------------------------*/

    virtual Boolean         isStructuredStorage() const;    
    Boolean                 isContainer() const;
    Boolean                 isEmbedded() const;
    
    INotifier&              notifier();    
    IGUIBundle&             bundle() const;
    IModel*                 model() const;
    IDocumentStorage&       storage() const;

    const IString&          documentName() const;


/*--------------------------- Title Components -------------------------------*/
    
    void                    setDocumentName( const IString& name );


/*--------------------- Sizing Notification Handlers -------------------------*/

    enum EAspect
    {
        kContent    = 1, // DVASPECT_CONTENT
        kThumbnail  = 2, // DVASPECT_THUMBNAIL
        kIcon       = 4, // DVASPECT_ICON
        kDocPrint   = 8  // DVASPECT_DOCPRINT
    };

    ISize                   handleGetArea( const EAspect ) const;
    void                    handleSetArea( const EAspect, const ISize& );
    

#ifdef IC_LIBRARYUSEONLY
    ISize                   contentSize() const;
    IComponentImp*          objectInstance() const;
    IUnknown*               objectInterface() const; // SMY0221
    void                    setInitialSize();
    const IString&          uniqueDocumentName() const;
    virtual Boolean         checkVerb( long iVerb ); // SMY0221
    
    static INotificationId  ContentsReplacedId;

#endif
    
private:
    IComponent&             operator=( const IComponent& );

    IString                 fDocumentName; // will be file name or "untitled"
    IString                 fUniqueDocumentName; // will be file name or unique time-stamped name
    IStandardNotifier       fNotifier;
    
    IModel*                 fpModel;
    IGUIBundle*             fpBundle;
    IDocumentStorage*       fpStorage;
    IComponentImp*          fpImplementation;

    ISize                   fExtent; // content extent in HiMetric

friend class IComponentImp;
friend class IModel;
};

  #include <icompnen.inl>


#pragma pack()


#endif // _ICOMPNEN_
