#ifndef _ICOMPNEN_INL_
#define _ICOMPNEN_INL_ 0
/*******************************************************************************
* FILE NAME: icompnen.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in icompnen.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICOMPNEN_
  #undef  _ICOMPNEN_INL_
  #define _ICOMPNEN_INL_ 1
  #include <icompnen.hpp>
#endif

#if _ICOMPNEN_INL_
  #define inline
#endif


//===============================================================================
//
// inline members of class IComponent
//

inline
INotifier&
IComponent::notifier()
{
    return fNotifier;
}
    
inline
IGUIBundle&
IComponent::bundle() const
{
    return *fpBundle;
}

inline
IModel*
IComponent::model() const
{
    return fpModel;
}

inline
IDocumentStorage&
IComponent::storage() const
{
    return *fpStorage;
}

inline
const IString&
IComponent::documentName() const
{
    return fDocumentName;
}

inline
IComponentImp*
IComponent::objectInstance() const
{
    return fpImplementation;
}

inline
IUnknown*
IComponent::objectInterface() const
{
    return (IUnknown*)fpImplementation;
}

#endif /* _ICOMPNEN_INL_ */

