#ifndef _ICONTROL_
  #define _ICONTROL_
/*******************************************************************************
* FILE NAME: icontrol.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IControl                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>

class IControlData;

#pragma pack(4)

class IControl : public IWindow  {
typedef IWindow
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
  ~IControl();

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, IControl, IWindow);
static const Style
  IC_IMPORTU group,
  IC_IMPORTU tabStop;

/*--------------------------- Groups and Tab Stops ---------------------------*/
virtual IControl
 &enableGroup    ( Boolean enable = true ),
 &disableGroup   ( );
virtual Boolean
  isGroup        ( ) const;
virtual IControl
 &enableTabStop  ( Boolean enable = true ),
 &disableTabStop ( );
virtual Boolean
  isTabStop      ( ) const;

protected:
/*------------------------------- Constructors -------------------------------*/
  IControl();

private:
/*------------------------------ Hidden Members ------------------------------*/
  IControl       ( const IControl& );
IControl
 &operator=      ( const IControl& );

/*--------------------------------- Private ----------------------------------*/
IControlData
 *fControlData;
}; // class IControl
INESTEDBITFLAGCLASSFUNCS(Style, IControl); // global style functions

#pragma pack()

#endif  /* _ICONTROL_ */
