#ifndef _ICOORDSY_
#define _ICOORDSY_
/*******************************************************************************
* FILE NAME: icoordsy.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     ICoordinateSystem                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

class IRectangle;
class IPoint;
class ISize;
class ICoordinateSystemData;

#pragma pack(4)


class ICoordinateSystem : public IBase {
typedef IBase
  Inherited;
public:

/*------------------------------- Orientation --------------------------------*/
enum Orientation {
  originUpperLeft,
  originLowerLeft
};

static Orientation
  nativeOrientation         ( ),
  applicationOrientation    ( ),
  setApplicationOrientation ( Orientation coordsystem = originLowerLeft );

/*-------------------------------- Conversion --------------------------------*/
static IRectangle
  convertToApplication ( const IRectangle& nativeRectangle,
                         const ISize&      referenceSize ),
  convertToNative      ( const IRectangle& applicationRectangle,
                         const ISize&      referenceSize );
static IPoint
  convertToApplication ( const IPoint&     nativePoint,
                         const ISize&      referenceSize ),
  convertToNative      ( const IPoint&     applicationPoint,
                         const ISize&      referenceSize );
static Boolean
  isConversionNeeded   ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  ICoordinateSystem ( );

/*--------------------------------- Private ----------------------------------*/
static Orientation
  fsapplication;
static IRectangle
  convertRectangle ( const IRectangle& rectangle,
                     const ISize&      referenceSize );
ICoordinateSystemData
 *fCoordinateSystemData;
}; // ICoordinateSystem


#pragma pack()

  #include <icoordsy.inl>

#endif /* _ICOORDSY_ */
