#ifndef _ICUSTBHD_
#define _ICUSTBHD_
/*******************************************************************************
* FILE NAME: icustbhd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICustomButtonDrawHandler                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icustbev.hpp>

#pragma pack(4)


class ICustomButtonDrawHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
   ICustomButtonDrawHandler();

virtual
  ~ICustomButtonDrawHandler();

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent(IEvent& event);

/*---------------------------- Event Processing ------------------------------*/
virtual Boolean
  drawButton           ( ICustomButtonDrawEvent& event );

virtual void
  drawBorder           ( ICustomButtonDrawEvent& event,
                         ISize                   margin = ISize() ),
  drawBackground       ( ICustomButtonDrawEvent& event ),
  drawForeground       ( ICustomButtonDrawEvent& event ),
  drawDisabledEmphasis ( ICustomButtonDrawEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
};


#pragma pack()

#endif /* ICUSTBHD */
