#ifndef _ICUSTBUT_
#define _ICUSTBUT_
/*******************************************************************************
* FILE NAME: icustbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICustomButton                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibutton.hpp>
#include <irect.hpp>
#include <icolor.hpp>

class ISize;
class ICustomButtonData;

#pragma pack(4)


class ICustomButton : public IButton {
typedef IButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  ICustomButton  ( unsigned long     id,
                   IWindow*          parent,
                   IWindow*          owner,
                   const IRectangle& initial = IRectangle(),
                   const Style&      style = defaultStyle() );

  ICustomButton ( const IWindowHandle& handle );

virtual
  ~ICustomButton ( );

/*-------------------------------- Style -------------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ICustomButton, IWindow, IControl, IButton);

static const Style
  IC_IMPORTU latchable,
  IC_IMPORTU autoLatch,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------ Latch Support -------------------------------*/
virtual ICustomButton
 &enableLatching   ( Boolean enable = true ),
 &disableLatching  ( ),
 &enableAutoLatch  ( Boolean enable = true ),
 &disableAutoLatch ( );

virtual Boolean
  isLatchingEnabled  ( ) const,
  isAutoLatchEnabled ( ) const;

virtual ICustomButton
 &latch        ( Boolean latched = true,
                 Boolean refresh = true ),
 &unlatch      ( );

virtual Boolean
  isLatched    ( ) const;

/*-------------------------------- Colors ------------------------------------*/
virtual IColor
  backgroundColor                  ( ) const,
  latchedForegroundColor           ( ) const,
  latchedBackgroundColor           ( ) const;

virtual ICustomButton
  &setLatchedForegroundColor       ( const IColor& color ),
  &setLatchedBackgroundColor       ( const IColor& color,
                                     Boolean       halftone = true ),
  &resetLatchedForegroundColor     ( ),
  &resetLatchedBackgroundColor     ( );

virtual Boolean
  isLatchedBackgroundColorHalftone ( ) const;

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  IC_IMPORTU latchId;

/*------------------------------- User Data ----------------------------------*/
unsigned long
  userData ( ) const;

ICustomButton
  &setUserData ( unsigned long data );

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

/*------------------------- Constructors -------------------------------------*/
  ICustomButton ( );

private:
/*--------------------------------- Private ----------------------------------*/
/*--------------------------- Hidden Members ---------------------------------*/
  ICustomButton             ( const ICustomButton& );
  ICustomButton& operator = ( const ICustomButton& );
static Style
  fgCurrentDefaultStyle;
ICustomButtonData
 *fCustomButtonData;
void
  checkAutoLatch ( );
};

INESTEDBITFLAGCLASSFUNCS(Style, ICustomButton);


#pragma pack()

#endif /* _ICUSTBUT_ */
