
#ifndef _IDATE_
#define _IDATE_
/*******************************************************************************
* FILE NAME: idate.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDate                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

/*  The "struct blocks" must be placed before SOM enablement test  */
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#endif

struct ICnrDate {
  unsigned char  day;
  unsigned char  month;
  unsigned short year;
};


#pragma pack(4)

class ostream;





class IString;

class IDate : public IBase {
public:
/*-------------------------- Day/Month/Year Declarations ---------------------*/
typedef enum {
  Monday = 0,
  Tuesday,
  Wednesday,
  Thursday,
  Friday,
  Saturday,
  Sunday
  } DayOfWeek;

typedef enum {
  January = 1,
  February,
  March,
  April,
  May,
  June,
  July,
  August,
  September,
  October,
  November,
  December
  } Month;

typedef enum {
  yy,
  yyyy
  } YearFormat;

/*-------------------------- Constructors ------------------------------------*/
  IDate       ( );

  IDate       ( Month aMonth,
                int   aDay,
                int   aYear );

  IDate       ( int   aDay,
                Month aMonth,
                int   aYear );

  IDate       ( int   aYear,
                int   aDay );

  IDate       ( const IDate&    aDate );

  IDate       ( unsigned long   julianDayNumber );

  IDate       ( const ICnrDate& cnrDate );

/*-------------------------- Current Date ------------------------------------*/
static IDate
  today       ( );

/*-------------------------- Diagnostics -------------------------------------*/
IString
  asString    ( YearFormat  yearFmt = yy ) const,
  asString    ( const char *fmt ) const;

friend ostream
 &operator << ( ostream     &aStream,
                const IDate &aDate );

/*-------------------------- Day Queries -------------------------------------*/
DayOfWeek
  dayOfWeek   ( ) const;

IString
  dayName     ( ) const;

int
  dayOfMonth  ( ) const,
  dayOfYear   ( ) const;

/*-------------------------- Month Queries -----------------------------------*/
Month
  monthOfYear ( ) const;

IString
  monthName   ( ) const;

/*-------------------------- Year Queries ------------------------------------*/
int
  year        ( ) const;

/*-------------------------- Date Queries ------------------------------------*/
unsigned long
  julianDate  ( ) const;

ICnrDate
  asICnrDate  ( ) const;

/*-------------------------- Comparisons -------------------------------------*/
Boolean
  operator == ( const IDate &aDate ) const,
  operator != ( const IDate &aDate ) const,
  operator <  ( const IDate &aDate ) const,
  operator <= ( const IDate &aDate ) const,
  operator >  ( const IDate &aDate ) const,
  operator >= ( const IDate &aDate ) const;

/*------------------------- Manipulations ------------------------------------*/
IDate
  operator +  ( int numDays ) const,
  operator -  ( int numDays ) const;

IDate
 &operator += ( int numDays ),
 &operator -= ( int numDays );

long
  operator -  ( const IDate &aDate ) const;

/*------------------------- General Date Queries -----------------------------*/
static IString
  dayName     ( DayOfWeek aDay   ),
  monthName   ( Month     aMonth );

static int
  daysInMonth ( Month aMonth,
                int   aYear ),
  daysInYear  ( int   aYear );

/*------------------------- Validation ---------------------------------------*/
static Boolean
  isLeapYear  ( int   aYear ),
  isValid     ( Month aMonth,
                int   aDay,
                int   aYear ),
  isValid     ( int   aDay,
                Month aMonth,
                int   aYear ),
  isValid     ( int   aYear,
                int   aDay );

protected:
/*------------------------- Initialize ---------------------------------------*/
IDate
 &initialize  ( Month aMonth,
                int   aDay,
                int   aYear );

private:
/*--------------------------------- Private ----------------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#endif

unsigned long
  julian;




}; // IDate



#pragma pack()

  #include <idate.inl>

#endif /* _IDATE_ */


