#ifndef _IDDECCNV_
#define _IDDECCNV_
/*******************************************************************************
* FILE NAME: iddeccnv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDEClientConversation                                                   *
*                                                                              *
*   NOTE:  IDDEActiveServer, IDDEActiveServerSet and IDDEClientHotLinkSet      *
*          are defined in iddecset.hpp.                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <istring.hpp>
#include <ihandle.hpp>
#include <ihandler.hpp>
#include <iddeevt.hpp>
#include <iddecomm.hpp>

class IObjectWindow;
class IDDEClosedConversationSet;
class IDDETransactionQueue;
class IDDEActiveServerSet;
class IDDEClientHotLinkSet;
class IDDEFormatSet;
class IThread;
class IDDEClientConversationData;

  class IDDEItemAtomSet;

#pragma pack(4)


class IDDEClientConversation : protected IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientConversation ( Boolean     useEventThread = true );
  IDDEClientConversation ( const char* applicationName,
                           const char* topicName,
                           Boolean     useEventThread = true );

virtual
 ~IDDEClientConversation ( );

/*------------------- Conversation Initiation/Termination --------------------*/
virtual Boolean
  begin ( const char* applicationName,
          const char* topicName );

virtual IDDEClientConversation
 &begin ( const IWindowHandle& serverHandle ),
 &end   ( );

/*------------------------------- Transactions -------------------------------*/
virtual IDDEClientConversation
 &requestData     ( const char*   item,
                    IDDE::Format  format = IDDE::textFormat ),
 &pokeData        ( const char*   item,
                    const void*   data,
                    unsigned long dataLength,
                    IDDE::Format  format = IDDE::textFormat ),
 &beginHotLink    ( const char*   item,
                    IDDE::Format  format = IDDE::textFormat,
                    Boolean       sendData = true,
                    Boolean       pacing = false ),
 &endHotLink      ( const char*   item,
                    IDDE::Format  format = IDDE::textFormat ),
 &endHotLinks     ( const char*   item = 0),
 &executeCommands ( const void*   commands,
                    unsigned long commandLength );

/*------------------------- Conversation Attributes ---------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

Boolean
  isCaseSensitive ( ) const,
  inConversation  ( ) const;

unsigned long
  outstandingTransactionCount ( ) const;

IWindowHandle
  clientHandle ( ) const;

/*--------------------------- Hot Link Information ---------------------------*/
IDDEClientConversation
 &hotLinks ( IDDEClientHotLinkSet& hotLinkSet );

unsigned long
  hotLinkCount ( ) const;

/*-------------------------------- Broadcasts --------------------------------*/
virtual IDDEClientConversation
 &supportedTopics        ( IDDEActiveServerSet& activeServerSet,
                           const char* applicationName = 0 ),
 &supportingApplications ( IDDEActiveServerSet& activeServerSet,
                           const char* topicName );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  data           ( IDDEDataEvent&          event) = 0,
  hotLinkInform  ( IDDEClientHotLinkEvent& event);

virtual void
  acknowledged        ( IDDEClientAcknowledgeEvent&  event ),
  executeAcknowledged ( IDDEAcknowledgeExecuteEvent& event ),
  pokeAcknowledged    ( IDDEAcknowledgePokeEvent&    event ),
  conversationEnded   ( IDDEClientEndEvent&          event );

/*--------------------- Event Processing Implementation ----------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

virtual void
  handleAck         ( const IEvent& ackEvent ),
  handleData        ( const IEvent& dataEvent ),
  handleInitiateAck ( const IEvent& initiateAckEvent ),
  handleTerminate   ( const IEvent& terminateEvent );

/*----------------------- Miscellaneous Implementation -----------------------*/
virtual void
  endAllHotLinks ( const char* item ),
  endAllHotLinks ( );

virtual Boolean
  findTransaction ( const IEvent& event,
                    Boolean       removeMatch = false );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IDDEClientConversation  ( const IDDEClientConversation& conversation );
IDDEClientConversation
 &operator=               ( const IDDEClientConversation& conversation );

/*--------------------------------- Private ----------------------------------*/
IWindowHandle
  serverHandle ( ) const;
IDDEClientHotLinkSet
 &hotLinksForUpdate ( ) const;
IDDEClosedConversationSet
 &closedConversations ( ) const;
IDDETransactionQueue
 &transactions ( ) const;
IDDEFormatSet
 &formats ( ) const;

IDDEItemAtomSet
 &itemAtoms ( ) const;

unsigned long
  queueHandle ( ) const;
void
  dispatchEventFromQueue ( );

void
 *buildDDEStruct ( int            ddeStructType,
                   const char*    dataFormat,
                   unsigned short status,
                   const void*    xferData,
                   unsigned long  dataLength );

unsigned long
 ulClQHandle,
 ulClSemaphore;
IThread
 *pThreadCl;
IWindowHandle
  wndhClServer,
  wndhClClient;
IObjectWindow
 *pwndClClient;
Boolean
  fClBrdcstInPrgrs,
  fClHdrActive,
  fClPostMsgFail,
  fClCaseSensitive;
IString
  strClTopic,
  strClApplication;
IDDEActiveServerSet
 *pActServSetCl;
IDDEClosedConversationSet
 *pClsdConvSetCl;
IDDEClientHotLinkSet
 *pHLSetCl;
IDDETransactionQueue
 *pTransQCl;
IDDEFormatSet
 *pFormatSetCl;

IDDEItemAtomSet
 *pItemAtomSetCl;

void
 *hReadPipe,
 *hWritePipe,
 *hFinish;

IDDEClientConversationData
 *fDDEClientConversationData;
}; // IDDEClientConversation


#pragma pack()

  #include <iddeccnv.inl>

#endif /* _IDDECCNV_ */
