#ifndef _IDDECCNV_INL_
#define _IDDECCNV_INL_ 0
/*******************************************************************************
* FILE NAME: iddeccnv.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in iddeccnv.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IDDECCNV_
  #undef  _IDDECCNV_INL_
  #define _IDDECCNV_INL_ 1
  #include <iddeccnv.hpp>
#endif

#if _IDDECCNV_INL_
  #define inline
#endif

inline IString IDDEClientConversation :: application ( ) const
{
   return strClApplication;
}

inline IString IDDEClientConversation :: topic ( ) const
{
   return strClTopic;
}

inline IBase::Boolean IDDEClientConversation :: isCaseSensitive ( ) const
{
   return fClCaseSensitive;
}

inline IWindowHandle IDDEClientConversation :: serverHandle ( ) const
{
   return wndhClServer;
}

inline IBase::Boolean IDDEClientConversation :: inConversation ( ) const
{
   if (serverHandle())
      return true;
   else
      return false;
}

inline IWindowHandle IDDEClientConversation :: clientHandle ( ) const
{
   return wndhClClient;
}

inline IDDEClosedConversationSet& IDDEClientConversation :: closedConversations ( ) const
{
   return *pClsdConvSetCl;
}

inline IDDETransactionQueue& IDDEClientConversation :: transactions ( ) const
{
   return *pTransQCl;
}

inline IDDEFormatSet& IDDEClientConversation :: formats ( ) const
{
   return *pFormatSetCl;
}

inline IDDEItemAtomSet& IDDEClientConversation :: itemAtoms ( ) const
{
   return *pItemAtomSetCl;
}

inline unsigned long IDDEClientConversation :: queueHandle ( ) const
{
   return ulClQHandle;
}

#endif // _IDDECCNV_INL_

