#ifndef _IDDECSET_
#define _IDDECSET_
/*******************************************************************************
* FILE NAME: iddecset.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDEActiveServer                                                         *
*     IDDEActiveServerSet                                                      *
*     IDDEClientHotLinkSet                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <istring.hpp>
#include <iddeevt.hpp>
#include <ireslock.hpp>
#include <iset.h>

#pragma pack(4)


class IDDEActiveServer : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEActiveServer ( const char* applicationName,
                     const char* topicName,
                     Boolean     caseSensitive );

 ~IDDEActiveServer ( );

/*---------------------------- Server Attributes -----------------------------*/
IString
  application ( ) const,
  topic       ( ) const;

Boolean
  isCaseSensitive ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IString
  strClApplication,
  strClTopic;
Boolean
  fClCaseSensitive;

}; // IDDEActiveServer

class IDDEActiveServerSet : public ISet<IDDEActiveServer*> {
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEActiveServerSet ( );

 ~IDDEActiveServerSet ( );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IDDEActiveServerSet ( const IDDEActiveServerSet& activeSet );
IDDEActiveServerSet
 &operator=           ( const IDDEActiveServerSet& activeSet );

}; // IDDEActiveServerSet

class IDDEClientHotLinkSet : public ISet<IDDEClientHotLinkEvent*> {
public:
/*------------------------------- Constructors -------------------------------*/
  IDDEClientHotLinkSet ( );
 ~IDDEClientHotLinkSet ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IDDEClientHotLinkSet ( const IDDEClientHotLinkSet& hotLinkSet );
IDDEClientHotLinkSet
 &operator=            ( const IDDEClientHotLinkSet& hotLinkSet );

/*--------------------------------- Private ----------------------------------*/
friend class IDDEClientConversation;

IPrivateResource
 &semaphor ( );

IPrivateResource
  priResCl;

}; // IDDEClientHotLinkSet


#pragma pack()

  #include <iddecset.inl>

#endif // _IDDECSET_
