#ifndef _IDDEEVT_INL_
#define _IDDEEVT_INL_ 0
/*******************************************************************************
* FILE NAME: iddeevt.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in iddeevt.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IDDEEVT_
  #undef  _IDDEEVT_INL_
  #define _IDDEEVT_INL_ 1
  #include <iddeevt.hpp>
#endif

#if _IDDEEVT_INL_
  #define inline
#endif

inline IString IDDEEvent :: item ( ) const
{
   return strClItem;
}

inline IString IDDEEvent :: format ( ) const
{
   return strClFormat;
}

inline IDDEEvent& IDDEEvent :: setStatus ( unsigned short status )
{
   usClStatus = status;
   return *this;
}

inline unsigned short IDDEEvent :: status ( ) const
{
   return usClStatus;
}

inline IDDEEvent& IDDEEvent :: setBuffer ( IString strBuf )
{
   strClData = strBuf;
   return *this;
}

inline IDDEEvent& IDDEEvent :: setFormat ( IString strFormat )
{
   strClFormat = strFormat;
   return *this;
}

inline IString IDDEEvent :: buffer ( ) const
{
   return strClData;
}

inline unsigned short IDDEAcknowledgeEvent :: transactionType ( ) const
{
   return (unsigned short)eventId();
}

inline IString IDDEServerAcknowledgeEvent :: data ( ) const
{
   return buffer();
}

inline IString IDDEAcknowledgePokeEvent :: pokedData ( ) const
{
   return buffer();
}

inline IString IDDEAcknowledgeExecuteEvent :: commands ( ) const
{
   return buffer();
}

inline IString IDDEDataEvent :: data ( ) const
{
   return buffer();
}

inline IString IDDEPokeEvent :: pokedData ( ) const
{
   return buffer();
}

inline IString IDDEExecuteEvent :: commands ( ) const
{
   return buffer();
}

inline IDDEEndEvent::Source IDDEEndEvent :: sourceOfEnd ( ) const
{
   return sourceCl;
}

inline IString IDDEClientEndEvent :: application ( ) const
{
   return strClApp;
}

inline IString IDDEClientEndEvent :: topic ( ) const
{
   return strClTopic;
}

inline IString IDDEBeginEvent :: application ( ) const
{
   return strClApp;
}

inline IString IDDEBeginEvent :: topic ( ) const
{
   return strClTopic;
}

inline IBase::Boolean IDDEBeginEvent :: isCaseSensitive ( ) const
{
   return bClCaseSens;
}

inline IDDEBeginEvent& IDDEBeginEvent :: setCaseSensitive ( Boolean caseSensitive )
{
   if (!caseSensitive)
      bClCaseSens = false;
   else
      bClCaseSens = true;
   return *this;
}

#endif // _IDDEEVT_INL_
