#ifndef _IDDETSRV_
#define _IDDETSRV_
/*******************************************************************************
* FILE NAME: iddetsrv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDDETopicServer                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <istring.hpp>
#include <ihandler.hpp>
#include <ihandle.hpp>
#include <iddeevt.hpp>

class IObjectWindow;
class IFrameWindow;
class IThread;
class IDDEServerConversationSet;
class IDDEServerHotLinkItemSet;
class IDDEFormatSet;
class IDDETopicServerData;

  class IDDEItemAtomSet;

#pragma pack(4)


class IDDETopicServer : protected IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDDETopicServer ( const char*   applicationName,
                    const char*   supportedTopic,
                    IFrameWindow* owner = 0,
                    Boolean       useEventThread = true );

virtual
 ~IDDETopicServer ( );

/*------------------- Conversation Initiation/Termination --------------------*/
virtual IDDETopicServer
 &beginConversation ( const IWindowHandle& clientHandle ),
 &endConversation   ( unsigned long conversationId );

/*----------------------------- Hot Link Updates -----------------------------*/
unsigned long
  hotLinkUpdate ( const char* item );

/*---------------------------- Server Attributes -----------------------------*/
unsigned long
  conversationCount ( ) const,
  hotLinkCount      ( ) const;

IString
  application ( ) const,
  topic       ( ) const;

IWindowHandle
  serverHandle ( ) const;

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  requestData        ( unsigned long           conversationId,
                       IDDERequestDataEvent&   event ) = 0,
  pokeData           ( unsigned long           conversationId,
                       IDDEPokeEvent&          event ),
  beginHotLink       ( unsigned long           conversationId,
                       IDDEServerHotLinkEvent& event ),
  executeCommands    ( unsigned long           conversationId,
                       IDDEExecuteEvent&       event ),
  acceptConversation ( unsigned long           conversationId,
                       IDDEBeginEvent&         event );

virtual void
  requestHotLinkData  ( IDDERequestDataEvent&       event ),
  hotLinkEnded        ( unsigned long               conversationId,
                        IDDEEvent&                  event ),
  acknowledged        ( unsigned long               conversationId,
                        IDDEServerAcknowledgeEvent& event ),
  conversationEnded   ( unsigned long               conversationId,
                        IDDEEndEvent&               event );

/*--------------------- Event Processing Implementation ----------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

virtual void
  handleAck       ( const IEvent& ackEvent ),
  handleAdvise    ( const IEvent& adviseEvent ),
  handleExecute   ( const IEvent& executeEvent ),
  handleInitiate  ( const IEvent& initiateEvent ),
  handlePoke      ( const IEvent& pokeEvent ),
  handleRequest   ( const IEvent& requestEvent ),
  handleTerminate ( const IEvent& terminateEvent ),
  handleUnadvise  ( const IEvent& unadviseEvent );

virtual Boolean
  removeLink ( IString       item,
               IString       format,
               unsigned long conversationId );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IDDETopicServer ( const IDDETopicServer& server );
IDDETopicServer
 &operator=( const IDDETopicServer& server );

/*--------------------------------- Private ----------------------------------*/
IDDEServerHotLinkItemSet
 &hotLinkItems ( ) const;
IDDEServerConversationSet
 &closedConversations ( ) const,
 &conversations       ( ) const;
IDDEFormatSet
 &formats ( ) const;

IDDEItemAtomSet
 &itemAtoms ( ) const;

unsigned long
  queueHandle ( ) const;

void
  dispatchEventFromQueue ( );

void
 *buildDDEStruct ( int            ddeStructType,
                   const char*    dataFormat,
                   unsigned short status,
                   const void*    xferData,
                   unsigned long  dataLength );

unsigned long
 ulClQHandle,
 ulClSemaphore;
IThread
 *pThreadCl;
Boolean
  fClHdrActive,
  fClPostMsgFail;
IWindowHandle
  wndhClServer;
IObjectWindow
 *pwndClServer;
IString
  strClTopic,
  strClApplication;
IDDEServerConversationSet
 *pConvSetCl;
IDDEServerHotLinkItemSet
 *pHLItemSetCl;
IDDEServerConversationSet
 *pClsdConvSetCl;
IDDEFormatSet
 *pFormatSetCl;

IDDEItemAtomSet
 *pItemAtomSetCl;

void
 *hReadPipe,
 *hWritePipe,
 *hFinish;

IDDETopicServerData
 *fDDETopicServerData;
}; // IDDETopicServer


#pragma pack()

  #include <iddetsrv.inl>

#endif /* _IDDETSRV_ */
