#ifndef _IDIEVT_
#define _IDIEVT_
/*******************************************************************************
* FILE NAME: idievt.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDrawItemEvent                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ictlevt.hpp>

class IPresSpaceHandle;
class IRectangle;

#pragma pack(4)

class IDrawItemEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDrawItemEvent ( const IEvent& event );

virtual
 ~IDrawItemEvent ( );

/*----------------------------- Item Information -----------------------------*/
virtual IPresSpaceHandle
  itemPresSpaceHandle ( ) const;

virtual unsigned long
  itemId              ( ) const;

virtual IRectangle
  itemRect            ( ) const;

protected:
/*------------------------------ Implementation ------------------------------*/
void
 *ownerItemData ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
void
 *pvOwnerItem;
}; // IDrawItemEvent

#pragma pack()

  #include <idievt.inl>

#endif /* _IDIEVT_ */
