#ifndef _IDMHNDLR_
#define _IDMHNDLR_
/*******************************************************************************
* FILE NAME: idmhndlr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMHandler                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>

class IDMSourceHandler;
class IDMTargetHandler;
class IDMRenderer;
class IDMRendererSeq;
class IWindow;
class IEntryField;
class IMultiLineEdit;
class IContainerControl;
class IMenuBar;
class ISubmenu;

class IToolBar;
class IToolBarButton;

class IDMHandlerData;

class IDMDropTargetHandler;
class IDMDragHandler;

#pragma pack(4)

class IDMHandler : public IHandler {
typedef IHandler
  Inherited;
public:

/*----------------------- Enabling Direct Manipulation -----------------------*/
static void
  enableDragFrom    ( IWindow*           window ),
  enableDragFrom    ( IEntryField*       entryField ),
  enableDragFrom    ( IMultiLineEdit*    mle ),
  enableDragFrom    ( IContainerControl* container ),
#ifndef IC_WIN_FLAGNOP
  enableDragFrom    ( IMenuBar*          menuBar ),
  enableDragFrom    ( ISubmenu*          submenu ),
#endif
  enableDropOn      ( IWindow*           window ),
  enableDropOn      ( IEntryField*       entryField ),
  enableDropOn      ( IMultiLineEdit*    mle ),
  enableDropOn      ( IContainerControl* container ),
  enableDropOn      ( IToolBar*          toolBar ),

  enableDragDropFor ( IWindow*           window ),
  enableDragDropFor ( IEntryField*       entryField ),
  enableDragDropFor ( IMultiLineEdit*    mle ),
  enableDragDropFor ( IContainerControl* container );

static void
  enableDragDropFor ( IToolBarButton*    toolBarButton );

/*----------------------------- Default Handlers -----------------------------*/
static IDMSourceHandler
 &defaultSourceHandler    ( );

static IDMTargetHandler
 &defaultTargetHandler    ( );

static IDMDropTargetHandler
 &defaultDropTargetHandler    ( );
static IDMDragHandler
 &defaultDragHandler      ( );

static void
  setDefaultSourceHandler ( IDMSourceHandler& source ),
  setDefaultTargetHandler ( IDMTargetHandler& target );


protected:
/*------------------------------- Constructors -------------------------------*/
  IDMHandler  ( );

virtual
  ~IDMHandler ( );

/*------------------------------ Item Providers ------------------------------*/
static void
  setItemProvider ( IEntryField*       entryField ),
  setItemProvider ( IMultiLineEdit*    mle ),
  setItemProvider ( IContainerControl* container );
#ifndef IC_WIN_FLAGNOP
static void
  setItemProvider ( ISubmenu*          submenu );
#endif
static void
  setItemProvider ( IToolBar*          toolBar ),
  setItemProvider ( IToolBarButton*    toolBar );

/*---------------------------- Handler Processing ----------------------------*/
Boolean
  isContainerControl ( const IWindow* window ) const;

/*-------------------------------- Rendering ---------------------------------*/
virtual unsigned
  numberOfRenderers  ( );

virtual IDMRenderer
 *renderer           ( unsigned           position );

virtual IDMHandler
 &replaceRenderer    ( unsigned           position,
                       const IDMRenderer& replacement ),
 &addRenderer        ( const IDMRenderer& newRenderer ),
 &removeRenderer     ( unsigned           position ),
 &removeRenderer     ( const IDMRenderer& rendererToRemove ),
 &setRenderer        ( const IDMRenderer& newRenderer );

private:
/*--------------------------------- Private ----------------------------------*/

static IDMSourceHandler
 *pSource;
static IDMTargetHandler
 *pTarget;
static IDMDropTargetHandler
 *pDropTarget;
static IDMDragHandler
 *pDragHandler;

IDMRendererSeq
 *pRendererSeqCl;

IDMRendererSeq
 *rendererCollection ( );

IDMHandlerData
 *fDMHandlerData;
}; // class IDMHandler

#pragma pack()

#endif // _IDMHNDLR_
