#ifndef _IDMIMAGE_
#define _IDMIMAGE_
/*******************************************************************************
* FILE NAME: idmimage.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMImage                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ipoint.hpp>
#include <ireslib.hpp>
#include <ibitflag.hpp>

struct _DRAGIMAGE;

class IDMImageData;

#pragma pack(4)

class IDMImage : public IVBase {
typedef IVBase
  Inherited;
public:

class Style;

/*------------------------------- Constructors -------------------------------*/
IDMImage    ( );
IDMImage    ( const IResourceId&    resourceId,
              Boolean               iconResource = true,
              const ISize&          pointerOffset = ISize(0,0),
              const ISize&          stretchSize = ISize(0,0),
              const Style&          style = defaultStyle() );

IDMImage    ( const IPointerHandle& icon,
              const ISize&          pointerOffset = ISize(0,0),
              const ISize&          stretchSize = ISize(0,0),
              const Style&          style = defaultStyle() );

IDMImage    ( const IBitmapHandle&  bitmap,
              const ISize&          pointerOffset = ISize(0,0),
              const ISize&          stretchSize = ISize(0,0),
              const Style&          style = defaultStyle() );

#ifndef IC_WIN_FLAGNOP
IDMImage    ( unsigned long         arrayOfPoints[],
              const unsigned long   numberOfPoints,
              const ISize&          pointerOffset = ISize(0,0),
              const Style&          style = defaultStyle() );
#endif

IDMImage    ( const IDMImage&       image );

virtual
  ~IDMImage ( );

IDMImage
 &operator = ( const IDMImage&      image );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, IDMImage);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU noStyle,
  IC_IMPORTU ptr,
  IC_IMPORTU bmp,
  IC_IMPORTU polygon,
  IC_IMPORTU stretch,
  IC_IMPORTU transparent,
  IC_IMPORTU closed;

static Style
  defaultStyle    ( );
static void
  setDefaultStyle ( const Style& style );

/*----------------------------- Image Processing -----------------------------*/
IPointerHandle
  pointer           ( ) const;

IBitmapHandle
  bitmap            ( ) const;

ISize
  pointerOffset     ( ) const,
  stretchSize       ( ) const;

Style
  style             ( );

#ifndef IC_WIN_FLAGNOP
unsigned long
  numberOfPoints    ( );

unsigned long
 *pointArray        ( );
#endif

IDMImage
 &setPointer        ( const IPointerHandle& pointerImage ),
 &setBitmap         ( const IBitmapHandle&  bitmapImage ),
 &setPointerOffset  ( const ISize&          pointerOffset ),
 &setStretchSize    ( const ISize&          stretchSize ),
 &setStyle          ( const Style&          style );

#ifndef IC_WIN_FLAGNOP
IDMImage
 &setNumberOfPoints ( unsigned long         points ),
 &setPointArray     ( unsigned long         arrayOfPoints[],
                      unsigned long         numberOfPoints );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
friend class IDMSourceOperation;

IPointerHandle
  pointerImage;

IBitmapHandle
  bitmapImage;


unsigned long
 *pPointArray;

ISize
  ptrOffset,
  imageStretchSize;

static Style
  currentDefaultStyle;

Style
  imgStyle;

unsigned long
  points;


IDMImageData
 *fDMImageData;

}; // IDMImage

#pragma pack()

  #include <idmimage.inl>

#endif //_IDMIMAGE_
