#ifndef _IDMIMAGE_INL_
  #define _IDMIMAGE_INL_ 0
/*******************************************************************************
* FILE NAME: idmimage.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in idmimage.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IDMIMAGE_
  #undef  _IDMIMAGE_INL_
  #define _IDMIMAGE_INL_ 1
  #include <idmimage.hpp>
#endif

#if _IDMIMAGE_INL_
  #define inline
#endif

inline IPointerHandle IDMImage::pointer () const
{
  return (this->pointerImage);
}

inline IBitmapHandle IDMImage::bitmap () const
{
  return (this->bitmapImage);
}

inline ISize IDMImage::pointerOffset () const
{
  return (this->ptrOffset);
}

inline ISize IDMImage::stretchSize () const
{
  return (this->imageStretchSize);
}

inline IDMImage::Style IDMImage::style ()
{
  return (this->imgStyle);
}

inline unsigned long IDMImage::numberOfPoints ()
{
  return (this->points);
}

inline unsigned long* IDMImage::pointArray()
{
  return (this->pPointArray);
}

inline IDMImage& IDMImage::setPointerOffset (const ISize& pointerOffset)
{
  this->ptrOffset = pointerOffset;
  return (*this);
}

inline IDMImage& IDMImage::setStyle (const Style& style)
{
  this->imgStyle = style;
  return (*this);
}

inline IDMImage& IDMImage::setNumberOfPoints (unsigned long pts)
{
  this->points = pts;
  return (*this);
}

#endif //IDMIMAGE
