#ifndef _IDMITEM_
#define _IDMITEM_
/*******************************************************************************
* FILE NAME: idmitem.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMItem                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <irefcnt.hpp>
#include <iwindow.hpp>
#include <idmcomm.hpp>
#include <istring.hpp>


class IDragItem;
typedef IDragItem _DRAGITEM;

struct IDataObject;

class IDMSourceRenderEvent;
class IDMSourcePrepareEvent;
class IDMSourceEndEvent;
class IDMSourceDiscardEvent;
class IDMSourcePrintEvent;
class IDMTargetDropEvent;
class IDMTargetEndEvent;
class IDMSourceOperation;
class IDMTargetOperation;
class IDMOperation;
class IDMRenderer;
class IDMSourceRenderer;
class IDMTargetRenderer;
class IDMImage;
class IDMItemData;
class IDragItemWrapper;
class IDMSourceOperationData;
class IDMTargetOperationData;
class IDMTargetRendererData;


#pragma pack(4)

class IDMItem : public IRefCounted {
typedef IRefCounted
  Inherited;
typedef IDM::DropIndicator
  DropIndicator;
public:
/*------------------------------ IDMItem::Handle -----------------------------*/
typedef IReference< IDMItem > Handle;

/*------------------------------- Constructors -------------------------------*/
  IDMItem ( IDMSourceOperation* sourceOperation,
            const IString&      types,
            const unsigned long supportedOperations = unknown,
            const unsigned long attributes = none);

  IDMItem ( IDMTargetOperation* targetOperation,
            _DRAGITEM*          dragItem );

  IDMItem ( const IDMItem&      dragItem );

  IDMItem ( const Handle&       item );

virtual
 ~IDMItem ( );

IDMItem
 &operator = ( const IDMItem& item );

Handle
  operator = ( const Handle&  item );

/*----------------------  Supported Operations Flags  ------------------------*/
static const unsigned long
  IC_IMPORTU unknown,
  IC_IMPORTU copyable,
  IC_IMPORTU moveable,
  IC_IMPORTU linkable;

/*----------------------------  Attribute Flags ------------------------------*/
static const unsigned long
  IC_IMPORTU none,
  IC_IMPORTU open,
  IC_IMPORTU reference,
  IC_IMPORTU group,
  IC_IMPORTU container,
  IC_IMPORTU prepare,
  IC_IMPORTU removableMedia;

/*-------------------------- Item Attributes ---------------------------------*/
virtual IWindowHandle
  sourceWindowHandle    ( ) const;

virtual IWindow
 *sourceWindow          ( ) const;

virtual IString
  containerName         ( ) const,
  sourceName            ( ) const,
  targetName            ( ) const;

virtual unsigned long
  attributes            ( ) const,
  supportedOperations   ( ) const;

virtual ISize
  imageOffset           ( ) const;

IDMItem
 &setSourceWindowHandle ( IWindowHandle window ),
 &setContainerName      ( const char*   containerName ),
 &setTargetName         ( const char*   targetName ),
 &setSourceName         ( const char*   sourceName );

virtual Boolean
  isOpen                 ( ) const,
  isReference            ( ) const,
  isGroup                ( ) const,
  isContainer            ( ) const,
  isOnRemovableMedia     ( ) const,
  requiresPreparation    ( ) const;

virtual IDMItem
 &setRequiresPreparation ( Boolean requiresPrep     = true ),
 &setOpen                ( Boolean open             = true ),
 &setReference           ( Boolean reference        = true ),
 &setGroup               ( Boolean group            = true ),
 &setContainer           ( Boolean container        = true ),
 &setOnRemovableMedia    ( Boolean onRemovableMedia = true );

/*-------------------------- Item Operations ---------------------------------*/
virtual Boolean
  canBeCopied            ( ) const,
  canBeLinked            ( ) const,
  canBeMoved             ( ) const;

virtual IDMItem
 &enableCopy             ( Boolean        copyable = true ),
 &enableLink             ( Boolean        linkable = true ),
 &enableMove             ( Boolean        moveable = true );

virtual unsigned long
  supportedOperationsFor ( const IString& selectedRMFs ) const;

/*-------------------------------- Item Types --------------------------------*/
virtual IString
  trueType          ( ) const,
  types             ( ) const;

virtual Boolean
  hasType           ( const char* aType ) const;

virtual IDMItem
 &setTrueType       ( const char* aType ),
 &setTypes          ( const char* types ),
 &addType           ( const char* aType ),
 &removeType        ( const char* aType );

/*---------------------  Rendering Mechanisms and Formats  -------------------*/
virtual IString
  nativeRMF    ( ) const,
  nativeRM     ( ) const,
  nativeRF     ( ) const,
  rmfs         ( ) const;

virtual Boolean
  supportsRMF  ( const IString& rmf ),
  supportsRMF  ( const IString& rm,
                 const IString& rf );

virtual IDMItem
 &setNativeRMF ( const IString& rmf ),
 &setNativeRMF ( const IString& rm,
                 const IString& rf ),
 &setRMFs      ( const IString& rmfs ),
 &addRMF       ( const IString& rmf ),
 &addRMF       ( const IString& rm,
                 const IString& rf ),
 &removeRMF    ( const IString& rmf ),
 &removeRMF    ( const IString& rm,
                 const IString& rf );

static void
  appendRMF        ( IString& rmfs,
                     const IString& rmf ),
  deleteRMF        ( IString& rmfs,
                     const IString& rmf );

static IString
  compressedRMFs   ( const IString& rmfs ),
  matchingRMFs     ( const IString& rmfs1,
                     const IString& rmfs2,
                     Boolean        firstOnly = false ),
  rfForThisProcess ( ),
  rfFrom           ( const IString& rmf ),
  rmfFrom          ( const IString& rm,
                     const IString& rf ),
  rmFrom           ( const IString& rmf ),
  rmfsFrom         ( const IString& rmfs ),
  rmfsFrom         ( const IString& rm,
                     const IString& rf );

/*---------------------------- Selected Renderer -----------------------------*/
unsigned
  renderer       ( ) const;

IString
  selectedRMF    ( ) const;

IDMItem
 &setRenderer    ( unsigned       position ),
 &setSelectedRMF ( const IString& rmf );

/*------------------------------- Drop Status --------------------------------*/
DropIndicator
  dropStatus    ( ) const;

IDMItem
 &setDropStatus ( DropIndicator status );

/*----------------------------- Item Rendering -------------------------------*/
virtual Boolean
  sourceRender  ( IDMSourceRenderEvent&  event ),
#ifndef IC_WIN_FLAGNOP
  sourcePrepare ( IDMSourcePrepareEvent& event ),
#endif
  sourceEnd     ( IDMSourceEndEvent&     event );

#ifndef IC_WIN_FLAGNOP
virtual Boolean
  sourceDiscard ( IDMSourceDiscardEvent& event ),
  sourcePrint   ( IDMSourcePrintEvent&   event );
#endif
virtual Boolean
  targetDrop    ( IDMTargetDropEvent&    event ),
  targetEnd     ( IDMTargetEndEvent&     event );

/*---------------------------- Drag Image Support ----------------------------*/
virtual IDMImage
 &image    ( );

virtual IDMItem
 &setImage ( IDMImage& image );

Boolean
  hasImage ( ) const;

/*------------------------------ Source Items --------------------------------*/
static Boolean
  generateSourceItems ( IDMSourceOperation* sourceOperation );

/*------------------------ Source and Target Operation -----------------------*/
virtual IDMSourceOperation
 *sourceOperation ( );

virtual IDMTargetOperation
 *targetOperation ( );

/*------------------------------ Item Contents -------------------------------*/
virtual IString
  contents     ( ) const;

virtual unsigned long
  contentsSize ( ) const;

virtual Boolean
  setContents  ( const IString& data );

virtual void
 *object       ( ) const;

virtual IDMItem
 &setObject    ( void*          pointerToObject );

/*--------------------------- Item Utilities ---------------------------------*/
static Handle
  sourceItemFor     ( const Handle& targetItem );

Boolean
  isTargetTheSource ( ) const;


protected:
/*-------------------------------- Source Name -------------------------------*/
IString
  generateSourceName ( );

/*--------------------------------- Item Data --------------------------------*/
IString
  strContents;


private:
/*--------------------------------- Private ----------------------------------*/
friend class IDMSourceOperation;
friend class IDMTargetOperation;
friend class IDMSourceRenderEvent;
friend class IDMSourceRenderer;
friend class IDMTargetRenderer;
friend class IDMTargetEndEvent;
friend class IDMItemUtilities;
friend class IDMTargetOperationData;
friend class IDragInfoWrapper;
friend class IDMSourceRendererData;
friend class IDMTargetRendererData;
friend class IDMItemData;

unsigned long
  dragSupOps,
  dragAttrs;

IWindowHandle
  sourceWndh;

IDMImage
 *pIDMImage;

ISize
  sizeImageOffset;

IString
  strContainerName,
  strSourceName,
  strTargetName,
  strTypes,
  strRMFs,
  strSelectedRMF;

IDMSourceOperation
 *pDMSrcOperation;

IDMTargetOperation
 *pDMTgtOperation;

unsigned
  rendererPosition;

DropIndicator
  drpStatus;

void
 *pObject;

Boolean
  bTargetTheSource;


IDragItemWrapper
 *pDragItemWrapper;

_DRAGITEM
 *PMDragItem    ( );

void
  setPMDragItem ( _DRAGITEM* pDragItem ),
  asPMDragItem  ( _DRAGITEM* pDragItem );

static IString
  stringFromHandle ( const IStringHandle& hstr ),
  nextRMOrRFFrom   ( const IString&       rmfs,
                     unsigned&            position );

IStringHandle
  handleFromString ( IString              inputStr);

static void
  setHSTR          ( unsigned long&       oldHSTR,
                     const IStringHandle& newHSTR );

IDMItemData
 *fDMItemData;

}; // IDMItem

#pragma pack()

  #include <idmitem.inl>

#endif // _IDMITEM_
