#ifndef _IDMSRCOP_
#define _IDMSRCOP_
/*******************************************************************************
* FILE NAME: idmsrcop.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMSourceOperation                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <irefcnt.hpp>
#include <idmoper.hpp>

class IDMSourceBeginEvent;
class IDMItemSeq;
class IDMImage;
class IDMSourceOperationData;

#pragma pack(4)


class IDMSourceOperation : public IDMOperation {
typedef IDMOperation
  Inherited;
typedef IDM::DragImageStyle
  DragImageStyle;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMSourceOperation     ( IDMSourceBeginEvent& event,
                           DragImageStyle       dragStyle = IDM::systemImages );

virtual
  ~IDMSourceOperation    ( );

/*------------------------ IDMSourceOperation::Handle ------------------------*/
typedef IReference< IDMSourceOperation > Handle;

/*---------------------------- Drag Image Support ----------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual DragImageStyle
  imageStyle            ( ) const;

IPair
  stackingPercentage    ( ) const;

virtual IDMSourceOperation
 &setImageStyle         ( DragImageStyle dragImageStyle = IDM::systemImages ),
 &setStackingPercentage ( const IPair&   stackingPercentage );
#endif

/*-------------------------- Pointing Device Position ------------------------*/
virtual ISize
  pointerOffset         ( ) const;

virtual IDMSourceOperation
 &setPointerOffset      ( const ISize&   offset );

/*----------------------------- Operation Services ---------------------------*/
virtual unsigned long
  operation          ( ) const;


static IDMSourceOperation::Handle
  sourceOperation    ( );

static void
  setSourceOperation ( IDMSourceOperation::Handle srcOperation );

/*------------------------------- Implementation -----------------------------*/
IDMSourceOperation
 &begin                 ( );

private:
/*--------------------------------- Private ----------------------------------*/

static IDMSourceOperation::Handle
  pDMSrcOpHandle;

ISize
  ptrOffset,
  totalImgOffset;

DragImageStyle
  drgImgStyle;

IPair
  stackingPct;

ISize
  totalImageOffset ( );

void
  storeImageOffset ( IDMImage* pIDMImage );

IDMSourceOperationData
 *fDMSourceOperationData;

}; // IDMSourceOperation

#pragma pack()

#endif //_IDMSRCOP_
