#ifndef _IDMTGTOP_
#define _IDMTGTOP_
/*******************************************************************************
* FILE NAME: idmtgtop.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDMTargetOperation                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idmoper.hpp>

class IDMItemSeq;
class IDMImage;
class IDMTargetOperationData;

#pragma pack(4)

class IDMTargetOperation : public IDMOperation {
typedef IDMOperation
  Inherited;
typedef IDM::DropStyle
  DropStyle;
public:

/*------------------------------- Constructors -------------------------------*/
  IDMTargetOperation  ( IDMTargetEnterEvent& event );

virtual
  ~IDMTargetOperation ( );

/*------------------------ IDMTargetOperation::Handle ------------------------*/
typedef IReference< IDMTargetOperation > Handle;

/*----------------------------- Operation Services ---------------------------*/
static IDMTargetOperation::Handle
  instanceFor        ( IDMTargetEnterEvent& event );

static IDMTargetOperation::Handle
  targetOperation    ( );

static void
  setTargetOperation ( IDMTargetOperation::Handle tgtOperation );

virtual Boolean
  firstTimeEntered () const;

IDMTargetOperation
 &setFirstTimeEntered ( Boolean  flag );

/*---------------------------- Container Support -----------------------------*/
Boolean
  wasDragAfter          ( ) const,
  isStyle               ( DropStyle              dropStyle );

IDMTargetOperation
 &setDropOffset         ( const ISize&           newPointerOffset ),
 &setStyle              ( DropStyle              dropStyle );

ISize
  dropOffset            ( ) const;

DropStyle
  style                 ( ) const;

IPoint
  dropPosition          ( const IDMItem::Handle& dragItem,
                          IDMTargetDropEvent&    event ),
  positionRelativeTo    ( const IDMItem::Handle& item,
                          IDMTargetDropEvent&    event );

private:
/*--------------------------------- Private ----------------------------------*/

friend class IDMTargetHandler;

static IDMTargetOperation::Handle
  pDMTgtOpHandle;

Boolean
  bWasDragAfter,
  bNotDragLeave,
  bDrop;

ISize
  sizeDropOffset;

DropStyle
  dropStyle;

IDMTargetOperationData
 *fDMTargetOperationData;

  Boolean
    bFirstTimeEntered;

}; // IDMTargetOperation

#pragma pack()

#endif //_IDMTGTOP_
