/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IDQU_H
#define _IDQU_H

#include <iadqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGDeque;

template <class Element, class ElementOps>
class IGDequeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGDeque
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeCursor
                            (IGDeque
                              <
                               Element, ElementOps> const&);

  IGDequeCursor <Element, ElementOps>&
           operator=        (IGDequeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGDeque :
  public IADeque <Element> {
protected:

  typedef  IGDeque <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeTypedef (Element, ElementOps);

public:

  typedef  IGDequeCursor
            <Element, ElementOps> Cursor;


           IGDeque
                            (INumber = 100);

           IGDeque
                            (IGDeque
                              <
                               Element, ElementOps> const&);

  IGDeque <Element, ElementOps>&
           operator=        (IGDeque
                              <
                               Element, ElementOps> const&);


protected:

           IGDeque
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDeque
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeCursor
            <Element, ElementOps>;



};

template <class Element>
class IDeque :
  public IGDeque
          <Element, IStdOps <Element> > {

  typedef  IGDeque
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IDeque <Element> Self;

#define IDequeTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IDeque
                            (INumber = 100);


protected:

           IDeque
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGDeque :
  public IGDeque
          <Element, ElementOps > {

  typedef  IVGDeque
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeTypedef (Element, ElementOps);

public:

           IVGDeque
                            (INumber = 100);


protected:

           IVGDeque
                              (PureImplementation&);

private:


};

template <class Element>
class IVDeque :
  public IVGDeque
          <Element, IStdOps <Element> > {

  typedef  IVGDeque
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVDeque <Element> Self;

#define IVDequeTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVDeque
                            (INumber = 100);


protected:

           IVDeque
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <idqu.inl>

#pragma info (restore)
#pragma pack ()

#endif
