/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IDQUDIL_H
#define _IDQUDIL_H

#include <iadqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGDequeAsDilTable;

template <class Element, class ElementOps>
class IGDequeAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGDequeAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeAsDilTableCursor
                            (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsDilTableCursor <Element, ElementOps>&
           operator=        (IGDequeAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGDequeAsDilTable :
  public IADeque <Element> {
protected:

  typedef  IGDequeAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGDequeAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGDequeAsDilTable
                            (INumber = 100);

           IGDequeAsDilTable
                            (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsDilTable <Element, ElementOps>&
           operator=        (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGDequeAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDequeAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IDequeAsDilTable :
  public IGDequeAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGDequeAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IDequeAsDilTable <Element> Self;

#define IDequeAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IDequeAsDilTable
                            (INumber = 100);


protected:

           IDequeAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGDequeAsDilTable :
  public IGDequeAsDilTable
          <Element, ElementOps > {

  typedef  IVGDequeAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeAsDilTableTypedef (Element, ElementOps);

public:

           IVGDequeAsDilTable
                            (INumber = 100);


protected:

           IVGDequeAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVDequeAsDilTable :
  public IVGDequeAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGDequeAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVDequeAsDilTable <Element> Self;

#define IVDequeAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVDequeAsDilTable
                            (INumber = 100);


protected:

           IVDequeAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <idqudil.inl>

#pragma info (restore)
#pragma pack ()

#endif
