/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGDequeAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGDequeAsDilTableCursor <Element, ElementOps>::
IGDequeAsDilTableCursor
  (IGDequeAsDilTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGDequeAsDilTableCursor <Element, ElementOps>&
IGDequeAsDilTableCursor <Element, ElementOps>::
operator=
  (IGDequeAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGDequeAsDilTableCursor <Element, ElementOps>::
IGDequeAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGDequeAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGDequeAsDilTable <Element, ElementOps>::
IGDequeAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGDequeAsDilTable <Element, ElementOps>::
IGDequeAsDilTable
  (IGDequeAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGDequeAsDilTable <Element, ElementOps>&
IGDequeAsDilTable <Element, ElementOps>::
operator= (IGDequeAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGDequeAsDilTable <Element, ElementOps>::
IGDequeAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGDequeAsDilTable
 <Element, ElementOps>::Implementation&
IGDequeAsDilTable <Element, ElementOps>::
ImplOf (IGDequeAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IDequeAsDilTable
// ---

// public members

template <class Element>
inline
IDequeAsDilTable <Element>::
IDequeAsDilTable (INumber numberOfElements)
: IGDequeAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IDequeAsDilTable <Element>::
IDequeAsDilTable (PureImplementation& impl)
: IGDequeAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGDequeAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGDequeAsDilTable <Element, ElementOps>::
IVGDequeAsDilTable (INumber numberOfElements)
: IGDequeAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGDequeAsDilTable <Element, ElementOps>::
IVGDequeAsDilTable (PureImplementation& impl)
: IGDequeAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVDequeAsDilTable
// ---

// public members

template <class Element>
inline
IVDequeAsDilTable <Element>::
IVDequeAsDilTable (INumber numberOfElements)
: IVGDequeAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVDequeAsDilTable <Element>::
IVDequeAsDilTable (PureImplementation& impl)
: IVGDequeAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}
