/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IDQUTAB_H
#define _IDQUTAB_H

#include <iadqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGDequeAsTable;

template <class Element, class ElementOps>
class IGDequeAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGDequeAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGDequeAsTableCursor
                            (IGDequeAsTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsTableCursor <Element, ElementOps>&
           operator=        (IGDequeAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGDequeAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGDequeAsTable :
  public IADeque <Element> {
protected:

  typedef  IGDequeAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGDequeAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGDequeAsTableTypedef (Element, ElementOps);

public:

  typedef  IGDequeAsTableCursor
            <Element, ElementOps> Cursor;


           IGDequeAsTable
                            (INumber = 100);

           IGDequeAsTable
                            (IGDequeAsTable
                              <
                               Element, ElementOps> const&);

  IGDequeAsTable <Element, ElementOps>&
           operator=        (IGDequeAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGDequeAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGDequeAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGDequeAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IDequeAsTable :
  public IGDequeAsTable
          <Element, IStdOps <Element> > {

  typedef  IGDequeAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IDequeAsTable <Element> Self;

#define IDequeAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IDequeAsTable
                            (INumber = 100);


protected:

           IDequeAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGDequeAsTable :
  public IGDequeAsTable
          <Element, ElementOps > {

  typedef  IVGDequeAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGDequeAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGDequeAsTableTypedef (Element, ElementOps);

public:

           IVGDequeAsTable
                            (INumber = 100);


protected:

           IVGDequeAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVDequeAsTable :
  public IVGDequeAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGDequeAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVDequeAsTable <Element> Self;

#define IVDequeAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVDequeAsTable
                            (INumber = 100);


protected:

           IVDequeAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <idqutab.inl>

#pragma info (restore)
#pragma pack ()

#endif
