/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGDequeAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGDequeAsTableCursor <Element, ElementOps>::
IGDequeAsTableCursor
  (IGDequeAsTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGDequeAsTableCursor <Element, ElementOps>&
IGDequeAsTableCursor <Element, ElementOps>::
operator=
  (IGDequeAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGDequeAsTableCursor <Element, ElementOps>::
IGDequeAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGDequeAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGDequeAsTable <Element, ElementOps>::
IGDequeAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGDequeAsTable <Element, ElementOps>::
IGDequeAsTable
  (IGDequeAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGDequeAsTable <Element, ElementOps>&
IGDequeAsTable <Element, ElementOps>::
operator= (IGDequeAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGDequeAsTable <Element, ElementOps>::
IGDequeAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGDequeAsTable
 <Element, ElementOps>::Implementation&
IGDequeAsTable <Element, ElementOps>::
ImplOf (IGDequeAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IDequeAsTable
// ---

// public members

template <class Element>
inline
IDequeAsTable <Element>::
IDequeAsTable (INumber numberOfElements)
: IGDequeAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IDequeAsTable <Element>::
IDequeAsTable (PureImplementation& impl)
: IGDequeAsTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGDequeAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGDequeAsTable <Element, ElementOps>::
IVGDequeAsTable (INumber numberOfElements)
: IGDequeAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGDequeAsTable <Element, ElementOps>::
IVGDequeAsTable (PureImplementation& impl)
: IGDequeAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVDequeAsTable
// ---

// public members

template <class Element>
inline
IVDequeAsTable <Element>::
IVDequeAsTable (INumber numberOfElements)
: IVGDequeAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVDequeAsTable <Element>::
IVDequeAsTable (PureImplementation& impl)
: IVGDequeAsTable
   <Element, IStdOps <Element> > (impl)
{
}
