#ifndef _IEMBMOD_INL_
#define _IEMBMOD_INL_ 0
/*******************************************************************************
* FILE NAME: iembmod.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in iembmod.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IEMBMOD_
  #undef  _IEMBMOD_INL_
  #define _IEMBMOD_INL_ 1
  #include <iembmod.hpp>
#endif

#if _IEMBMOD_INL_
  #define inline
#endif


//===============================================================================
//
// inline members of class IEmbeddedComponent
//

inline
IGrabHandles*
IEmbeddedComponent::grabHandles() const
{
    return fpGrabHandles;
}

inline
IComponent::EAspect
IEmbeddedComponent::aspect() const
{
    return fAspect;
}

inline
const IRectangle&
IEmbeddedComponent::area() const
{
    return fArea;
}

inline
void
IEmbeddedComponent::setArea( const IRectangle& r )
{
    fArea = r;
}

inline
IGUIBundle&
IEmbeddedComponent::bundle() const
{
    return *fpBundle;
}

inline
unsigned
IEmbeddedComponent::number() const
{
    return fNumber;
}

inline
IEmbeddedComponentImp*
IEmbeddedComponent::containedObject() const
{
    return fpImplementation;
}

inline
IUnknown*
IEmbeddedComponent::objectInterface() const
{
    return (IUnknown*)fpImplementation;
}

inline
IPoint
IEmbeddedComponent::dragMouseOffset() const
{
    return ftDragMouseOffset;
}


//===============================================================================
//
// inline members of class IEmbedderModel
//

inline
const IEmbedderModel::ComponentList&
IEmbedderModel::componentList() const
{
    return fComponentList;
}

inline
IEmbeddedComponent*
IEmbedderModel::selectedComponent() const
{
    return fpSelectedComponent;
}

inline
CAswContainer*
IEmbedderModel::container() const
{
    return fpContainer;
}

inline
CAswRootContainer*
IEmbedderModel::rootContainer() const
{
    return fpRootContainer;
}


#endif /* _IEMBMOD_INL_ */
