/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGEqualitySequenceAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsDilTableCursor <Element, ElementOps>::
IGEqualitySequenceAsDilTableCursor
  (IGEqualitySequenceAsDilTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsDilTableCursor <Element, ElementOps>&
IGEqualitySequenceAsDilTableCursor <Element, ElementOps>::
operator=
  (IGEqualitySequenceAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsDilTableCursor <Element, ElementOps>::
IGEqualitySequenceAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGEqualitySequenceAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsDilTable <Element, ElementOps>::
IGEqualitySequenceAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsDilTable <Element, ElementOps>::
IGEqualitySequenceAsDilTable
  (IGEqualitySequenceAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsDilTable <Element, ElementOps>&
IGEqualitySequenceAsDilTable <Element, ElementOps>::
operator= (IGEqualitySequenceAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsDilTable <Element, ElementOps>::
IGEqualitySequenceAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsDilTable
 <Element, ElementOps>::Implementation&
IGEqualitySequenceAsDilTable <Element, ElementOps>::
ImplOf (IGEqualitySequenceAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IEqualitySequenceAsDilTable
// ---

// public members

template <class Element>
inline
IEqualitySequenceAsDilTable <Element>::
IEqualitySequenceAsDilTable (INumber numberOfElements)
: IGEqualitySequenceAsDilTable
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IEqualitySequenceAsDilTable <Element>::
IEqualitySequenceAsDilTable (PureImplementation& impl)
: IGEqualitySequenceAsDilTable
   <Element, IEOps <Element> > (impl)
{
}

// ---
// IVGEqualitySequenceAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGEqualitySequenceAsDilTable <Element, ElementOps>::
IVGEqualitySequenceAsDilTable (INumber numberOfElements)
: IGEqualitySequenceAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGEqualitySequenceAsDilTable <Element, ElementOps>::
IVGEqualitySequenceAsDilTable (PureImplementation& impl)
: IGEqualitySequenceAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVEqualitySequenceAsDilTable
// ---

// public members

template <class Element>
inline
IVEqualitySequenceAsDilTable <Element>::
IVEqualitySequenceAsDilTable (INumber numberOfElements)
: IVGEqualitySequenceAsDilTable
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVEqualitySequenceAsDilTable <Element>::
IVEqualitySequenceAsDilTable (PureImplementation& impl)
: IVGEqualitySequenceAsDilTable
   <Element, IEOps <Element> > (impl)
{
}
