/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IESLST_H
#define _IESLST_H

#include <iaes.h>
#include <iices.h>
#include <iives.h>
#include <iieslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGEqualitySequenceAsList;

template <class Element, class ElementOps>
class IGEqualitySequenceAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGEqualitySequenceAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGEqualitySequenceAsListCursor
                            (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsListCursor <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGEqualitySequenceAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGEqualitySequenceAsList :
  public IAEqualitySequence <Element> {
protected:

  typedef  IGEqualitySequenceAsList <Element, ElementOps> Self;

  typedef  IEqualitySequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGEqualitySequenceAsListTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGEqualitySequenceAsListTypedef (Element, ElementOps);

public:

  typedef  IGEqualitySequenceAsListCursor
            <Element, ElementOps> Cursor;


           IGEqualitySequenceAsList
                            (INumber = 100);

           IGEqualitySequenceAsList
                            (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsList <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGEqualitySequenceAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGEqualitySequenceAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGEqualitySequenceAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class IEqualitySequenceAsList :
  public IGEqualitySequenceAsList
          <Element, IEOps <Element> > {

  typedef  IGEqualitySequenceAsList
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef  IEqualitySequenceAsList <Element> Self;

#define IEqualitySequenceAsListTypedef(Element)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

           IEqualitySequenceAsList
                            (INumber = 100);


protected:

           IEqualitySequenceAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGEqualitySequenceAsList :
  public IGEqualitySequenceAsList
          <Element, ElementOps > {

  typedef  IVGEqualitySequenceAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVEqualitySequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <IVEqualitySequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGEqualitySequenceAsListTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGEqualitySequenceAsListTypedef (Element, ElementOps);

public:

           IVGEqualitySequenceAsList
                            (INumber = 100);


protected:

           IVGEqualitySequenceAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVEqualitySequenceAsList :
  public IVGEqualitySequenceAsList
          <Element, IEOps <Element> > {

  typedef  IVGEqualitySequenceAsList
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef  IVEqualitySequenceAsList <Element> Self;

#define IVEqualitySequenceAsListTypedef(Element)\
  typedef  IVEqualitySequenceAsListOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

           IVEqualitySequenceAsList
                            (INumber = 100);


protected:

           IVEqualitySequenceAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ieslst.inl>

#pragma info (restore)
#pragma pack ()

#endif
