/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IESTAB_H
#define _IESTAB_H

#include <iaes.h>
#include <iices.h>
#include <iives.h>
#include <iiestab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGEqualitySequenceAsTable;

template <class Element, class ElementOps>
class IGEqualitySequenceAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGEqualitySequenceAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGEqualitySequenceAsTableCursor
                            (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsTableCursor <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGEqualitySequenceAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGEqualitySequenceAsTable :
  public IAEqualitySequence <Element> {
protected:

  typedef  IGEqualitySequenceAsTable <Element, ElementOps> Self;

  typedef  IEqualitySequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGEqualitySequenceAsTableTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGEqualitySequenceAsTableTypedef (Element, ElementOps);

public:

  typedef  IGEqualitySequenceAsTableCursor
            <Element, ElementOps> Cursor;


           IGEqualitySequenceAsTable
                            (INumber = 100);

           IGEqualitySequenceAsTable
                            (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGEqualitySequenceAsTable <Element, ElementOps>&
           operator=        (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGEqualitySequenceAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGEqualitySequenceAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGEqualitySequenceAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IEqualitySequenceAsTable :
  public IGEqualitySequenceAsTable
          <Element, IEOps <Element> > {

  typedef  IGEqualitySequenceAsTable
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef  IEqualitySequenceAsTable <Element> Self;

#define IEqualitySequenceAsTableTypedef(Element)\
  typedef  IEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

           IEqualitySequenceAsTable
                            (INumber = 100);


protected:

           IEqualitySequenceAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGEqualitySequenceAsTable :
  public IGEqualitySequenceAsTable
          <Element, ElementOps > {

  typedef  IVGEqualitySequenceAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVEqualitySequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICEqualitySequenceImpl
            <IVEqualitySequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGEqualitySequenceAsTableTypedef(Element, ElementOps)\
  typedef  IEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGEqualitySequenceAsTableTypedef (Element, ElementOps);

public:

           IVGEqualitySequenceAsTable
                            (INumber = 100);


protected:

           IVGEqualitySequenceAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVEqualitySequenceAsTable :
  public IVGEqualitySequenceAsTable
          <Element, IEOps <Element> > {

  typedef  IVGEqualitySequenceAsTable
            <Element,
             IEOps <Element> > Inherited;

protected:

  typedef  IVEqualitySequenceAsTable <Element> Self;

#define IVEqualitySequenceAsTableTypedef(Element)\
  typedef  IVEqualitySequenceAsTableOps\
            <Element,\
             IWEOps <Element, IEOps <Element> >,\
             Implementation> Instantiation

public:

           IVEqualitySequenceAsTable
                            (INumber = 100);


protected:

           IVEqualitySequenceAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iestab.inl>

#pragma info (restore)
#pragma pack ()

#endif
