/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGEqualitySequenceAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsTableCursor <Element, ElementOps>::
IGEqualitySequenceAsTableCursor
  (IGEqualitySequenceAsTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsTableCursor <Element, ElementOps>&
IGEqualitySequenceAsTableCursor <Element, ElementOps>::
operator=
  (IGEqualitySequenceAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsTableCursor <Element, ElementOps>::
IGEqualitySequenceAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGEqualitySequenceAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsTable <Element, ElementOps>::
IGEqualitySequenceAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsTable <Element, ElementOps>::
IGEqualitySequenceAsTable
  (IGEqualitySequenceAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsTable <Element, ElementOps>&
IGEqualitySequenceAsTable <Element, ElementOps>::
operator= (IGEqualitySequenceAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGEqualitySequenceAsTable <Element, ElementOps>::
IGEqualitySequenceAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGEqualitySequenceAsTable
 <Element, ElementOps>::Implementation&
IGEqualitySequenceAsTable <Element, ElementOps>::
ImplOf (IGEqualitySequenceAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IEqualitySequenceAsTable
// ---

// public members

template <class Element>
inline
IEqualitySequenceAsTable <Element>::
IEqualitySequenceAsTable (INumber numberOfElements)
: IGEqualitySequenceAsTable
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IEqualitySequenceAsTable <Element>::
IEqualitySequenceAsTable (PureImplementation& impl)
: IGEqualitySequenceAsTable
   <Element, IEOps <Element> > (impl)
{
}

// ---
// IVGEqualitySequenceAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGEqualitySequenceAsTable <Element, ElementOps>::
IVGEqualitySequenceAsTable (INumber numberOfElements)
: IGEqualitySequenceAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGEqualitySequenceAsTable <Element, ElementOps>::
IVGEqualitySequenceAsTable (PureImplementation& impl)
: IGEqualitySequenceAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVEqualitySequenceAsTable
// ---

// public members

template <class Element>
inline
IVEqualitySequenceAsTable <Element>::
IVEqualitySequenceAsTable (INumber numberOfElements)
: IVGEqualitySequenceAsTable
   <Element, IEOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVEqualitySequenceAsTable <Element>::
IVEqualitySequenceAsTable (PureImplementation& impl)
: IVGEqualitySequenceAsTable
   <Element, IEOps <Element> > (impl)
{
}
