#ifndef _IEVENT_
#define _IEVENT_
/*******************************************************************************
* FILE NAME: ievent.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IEvent                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ievtdata.hpp>
#include <ihandle.hpp>

class IEventPrivateData;
class IWindow;

#pragma pack(4)

class IEvent : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IEvent    ( const IWindowHandle&    handle,
              unsigned long           eventId,
              const IEventParameter1& parameter1,
              const IEventParameter2& parameter2 );

  IEvent    ( IWindow*                window,
              unsigned long           eventId,
              const IEventParameter1& parameter1,
              const IEventParameter2& parameter2 );

  IEvent    ( const IEvent&           event );

IEvent
 &operator= ( const IEvent&           event );

virtual
 ~IEvent    ( );

/*-------------------------------- Event Data --------------------------------*/
unsigned long
  eventId    ( ) const;

IEventParameter1
  parameter1 ( ) const;

IEventParameter2
  parameter2 ( ) const;

IEventResult
  result     ( ) const;

IEvent
 &setResult  ( const IEventResult& eventResult ),
 &setResult  ( Boolean             eventResult );


/*------------------------------- Event Window -------------------------------*/
virtual IWindow
 *window               ( ) const,
 *dispatchingWindow    ( ) const,
 *controlWindow        ( ) const;

IWindowHandle
  handle               ( ) const,
  controlHandle        ( ) const;

IEvent
 &setHandle            ( const IWindowHandle& handle ),
 &setDispatchingHandle ( const IWindowHandle& handle ),
 &setControlHandle     ( const IWindowHandle& handle );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IWindow;
IWindowHandle
  hCl,
  p_dispatchingHandle,
  p_controlHandle;
unsigned long
  ulClEvtId;
IEventData
  epCl1,
  epCl2;
IEventResult
  erCl;
IEventPrivateData
 *pData;
}; // IEvent

#pragma pack()

  #include <ievent.inl>

#endif /* _IEVENT_ */
