#ifndef _IFILEDLG_INL_
#define _IFILEDLG_INL_ 0
/*******************************************************************************
* FILE NAME: ifiledlg.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ifiledlg.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IFILEDLG_
  #undef  _IFILEDLG_INL_
  #define _IFILEDLG_INL_ 1
  #include <ifiledlg.hpp>
#endif

#if _IFILEDLG_INL_
  #define inline
#endif

inline IFileDialog::Settings&  IFileDialog::Settings :: setOpenDialog ( )
{
  isOpenDlg = true;
  return *this;
}

inline IFileDialog::Settings&  IFileDialog::Settings :: setSaveAsDialog ( )
{
  isOpenDlg = false;
  return *this;
}

inline IBase::Boolean  IFileDialog::Settings :: isOpenDialog ( ) const
{
  return isOpenDlg;
}

inline IFileDialog::Settings&
  IFileDialog::Settings :: setPosition ( const IPoint& position )
{
  isPosSet = true;
  pos = position;
  return *this;
}

inline IBase::Boolean  IFileDialog::Settings :: isPositionSet ( ) const
{
  return isPosSet;
}

inline IPoint  IFileDialog::Settings :: position ( ) const
{
  return pos;
}

inline IString  IFileDialog::Settings :: title ( ) const
{
  return titleStr;
}

inline IString  IFileDialog::Settings :: okButtonText ( ) const
{
  return OKButtonStr;
}

inline IString  IFileDialog::Settings :: fileName ( ) const
{
  return fileNameStr;
}

inline IString  IFileDialog::Settings :: initialDrive ( ) const
{
  return initialDriveStr;
}

inline IString  IFileDialog::Settings :: initialFileType ( ) const
{
  return initialFileTypeStr;
}


#endif // _IFILEDLG_INL_
