#ifndef _IFLYHHDR_
#define _IFLYHHDR_
/*******************************************************************************
* FILE NAME: iflyhhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFlyOverHelpHandler                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ihandler.hpp>
#include <istring.hpp>


class IModuleHandle;
class IWindowHandle;
class ITextControl;
class IFlyOverData;
class IFlyText;
class IResourceLibrary;
class IResourceId;

#pragma pack(4)

class IFlyOverHelpHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IFlyOverHelpHandler ( IFlyText*     flyText,
                        unsigned long initialDelay = 100,
                        unsigned long delay        = 100 );


  IFlyOverHelpHandler ( ITextControl* longText,
                        unsigned long initialDelay = 100,
                        unsigned long delay        = 100 );

  IFlyOverHelpHandler ( IFlyText*     flyText,
                        ITextControl* longText,
                        unsigned long initialDelay = 100,
                        unsigned long delay        = 100 );

virtual
  ~IFlyOverHelpHandler ( );

/*--------------------- Querying and Setting Text Controls -------------------*/
virtual IFlyOverHelpHandler
 &setFlyTextControl   ( IFlyText*     flyText   ),
 &setLongTextControl  ( ITextControl* longText  );

virtual IFlyText
 *flyTextControl      ( ) const;
virtual ITextControl
 *longTextControl     ( ) const;


/*----------------------------- Resource Library -----------------------------*/
virtual IResourceLibrary
 &resourceLibrary       ( ) const;

virtual IFlyOverHelpHandler
 &setResourceLibrary    ( const IModuleHandle& resMod     ),
 &setResourceLibrary    ( const char*          resDLLName );

/*--------------------------- String Table Offset ----------------------------*/
virtual IFlyOverHelpHandler
 &setFlyTextStringTableOffset ( long newOffset = 0 ),
 &setLongStringTableOffset    ( long newOffset = 0 );

virtual long
  flyTextStringTableOffset    ( ) const,
  longStringTableOffset       ( ) const;

/*----------------------- Special Information Strings ------------------------*/
virtual IFlyOverHelpHandler
 &setDefaultText        ( unsigned long  identifier                ),
 &setDefaultText        ( const IString& defaultText               );

virtual IString
  defaultText           ( ) const;

/*----------------------- Dynamically Updating Help Text ---------------------*/
virtual IFlyOverHelpHandler
 &setHelpText           ( const IWindowHandle& handle,
                          const IString&       flyText,
                          const IString&       longText = IString()),

 &setHelpText           ( const IWindowHandle& handle,
                          const IResourceId&   flyText,
                          const IResourceId&   longText            ),

 &removeHelpText        ( const IWindowHandle& handle              );

virtual IString
  flyHelpText           ( const IWindowHandle& handle              ) const,
  longHelpText          ( const IWindowHandle& handle              ) const;

/*------------------------------ Timer Delay ---------------------------------*/
virtual IFlyOverHelpHandler
 &setDelayTime        ( unsigned long milliseconds = 100 );

virtual unsigned long
  delayTime           ( ) const;

virtual IFlyOverHelpHandler
 &setInitialDelayTime ( unsigned long milliseconds = 100 );

virtual unsigned long
  initialDelayTime    ( ) const;

/*---------------------------- Event Dispatching -----------------------------*/
virtual IFlyOverHelpHandler
  &handleEventsFor        ( IWindow* window ),
  &stopHandlingEventsFor  ( IWindow* window );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent( IEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
IFlyOverData
  *fFlyOverData;

}; // IFlyOverHelpHandler

#pragma pack()

#endif // _IFLYHHDR_
