#ifndef _IFLYTEXT_
#define _IFLYTEXT_
/*******************************************************************************
* FILE NAME: iflytext.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFlyText                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <iglist.hpp>
#include <irect.hpp>


class IGPolygon;
class IGPolyline;
class IResourceId;
class IFlyTextData;

#pragma pack(4)

class IFlyText : public ITextControl {
typedef ITextControl
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IFlyText ( unsigned long identifier,
             IWindow*      owner      );
virtual
  ~IFlyText( );

/*---------------------------------- Text ------------------------------------*/
virtual IFlyText
 &setText       ( const char*        text ),
 &setText       ( const IResourceId& text );

/*--------------------------- Window Positioning -----------------------------*/
virtual IFlyText
 &setRelativeWindowRect ( const IRectangle& rect );

virtual IRectangle
  relativeWindowRect    ( ) const;

/*----------------------------- Window Painting ------------------------------*/
virtual IWindow
 &hide ( );

private:
/*--------------------------------- Private ----------------------------------*/
enum ArrowPos {
  upperRight,
  upperLeft,
  lowerRight,
  lowerLeft };
IFlyTextData
 *fFlyTextData;
IGList
  fHelpArrow;
IGPolygon
 *fArrow;
IGPolyline
 *fBorderArrow;
ArrowPos
  fArrowPos;
IRectangle
  fWinrc;

/*------------------------------ Hidden Functions ----------------------------*/
  IFlyText  ( const IFlyText& );
IFlyText
 &operator= ( const IFlyText& );

static IRectangle
  fgScreen;
static Boolean
  fgRegistered;
friend class IFlyTextPaintHandler;
}; // IFlyText

#pragma pack()

#endif // _IFLYTEXT_
