#ifndef _IFOCSHDR_
  #define _IFOCSHDR_
/*******************************************************************************
* FILE NAME: ifocshdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFocusHandler                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ictlevt.hpp>

#pragma pack(4)

class IFocusHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*---------------------------- Constructors ----------------------------------*/
  IFocusHandler        ( );
virtual
 ~IFocusHandler        ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  gotFocus             ( IControlEvent& event ),
  lostFocus            ( IControlEvent& event );
};

#pragma pack()

#endif /* _IFOCSHDR_ */
