#ifndef _IFONT_
  #define _IFONT_
/*******************************************************************************
* FILE NAME: IFONT.HPP                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFont                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ihandle.hpp>

extern "C" {
  extern void* __stdcall _IFontDlgProc( void*, unsigned long, void*, void* );
}

class IString;
class IWindow;
class IFontDialog;
class IPoint;
class ISize;
class IFontPrivateData;
class IBidiSettings;

struct _FATTRS;
struct _FONTMETRICS;
struct tagLOGFONTA;

#pragma pack(4)

class IFont : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IFont         (const IWindow* window = 0);

  IFont         (const char*    faceName,
                 unsigned long  pointSize = 0,
                 Boolean        useFixedFont = false,
                 Boolean        useVectorFont = false,
                 const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());

  IFont         (const IPresSpaceHandle& presSpaceHandle);

  IFont         (const IFont&            fntCopy);

  IFont&        operator=(const IFont&   font);

virtual
 ~IFont         ( );

/*--------------------- Setting General Font Attributes ----------------------*/
virtual IFont
 &setName       (const char* name,
                 const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setPointSize  (unsigned long size,
                 const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());

/*------------------- Setting Font Style -------------------------------------*/
virtual IFont
 &setUnderscore     (Boolean underscore = true),
 &setStrikeout      (Boolean strikeout  = true),
 &setOutline        (Boolean outline    = true),
 &setBold           (Boolean bold       = true),
 &setItalic         (Boolean italics    = true),
 &setAllEmphasis    (Boolean turnOn     = true);

/*------------------- Getting Font Style -------------------------------------*/
Boolean
  isUnderscore      ( ) const,
  isStrikeout       ( ) const,
  isOutline         ( ) const,
  isBold            ( ) const,
  isItalic          ( ) const;

/*------------------------- Getting Font Attributes --------------------------*/
Boolean
  isBitmap          ( ) const,
  isFixed           ( ) const;

IString
  name              ( ) const;

unsigned long
  pointSize         ( ) const;

/*------------------------ Setting Font Direction ----------------------------*/
enum Direction {
  defaultDir,
  leftToRight,
  topToBottom,
  rightToLeft,
  bottomToTop
};

virtual IFont
 &setDirection      (Direction direction);


ISize
  maxSize           ( ) const,
  maxUppercaseSize  ( ) const;

unsigned long
  charWidth         (char c) const,
  textWidth         (const char* text) const,
  textWidth         (const char* text, IBidiSettings& settings) const,
  minTextWidth      (const char* line) const,
  textLines         (const char* text,
                     unsigned long lineWidth) const,
  maxAscender       ( ) const,
  maxDescender      ( ) const,
  internalLeading   ( ) const,
  externalLeading   ( ) const,
  maxCharHeight     ( ) const,
  avgCharWidth      ( ) const;


/*---------------------- Setting Window Font ---------------------------------*/
virtual Boolean
  setWindowFont    (IWindow* window) const;

/*--------------------- Setting Vector Font Attributes -----------------------*/
virtual IFont
 &setCharWidth   (unsigned long width,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setCharHeight  (unsigned long height,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setCharSize    (const ISize& size,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setFontAngle   (const IPoint& point,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setFontShear   (const IPoint& point,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());

/*--------------------- Drawing Functions ------------------------------------*/
virtual IFont
 &beginUsingFont     (const IPresSpaceHandle& presSpaceHandle),
 &endUsingFont       (const IPresSpaceHandle& presSpaceHandle);

/*-------------------------------- Font Types --------------------------------*/
virtual IFont
 &useNonPropOnly  (Boolean nonProportionalOnly = true,
                   const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &useBitmapOnly   (Boolean bitmapOnly = true,
                   const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &useVectorOnly   (Boolean vectorOnly = true,
                   const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());

Boolean
  isNonPropOnly    () const,
  isBitmapOnly     () const,
  isVectorOnly     () const;

/*---------- Accessing Presentation Manager Structures Related to Font -------*/

const struct tagLOGFONTA
 *logfont     () const;


class FaceNameCursor : public IVBase {
public:
/*-------------------------------- Font Type ---------------------------------*/
enum FontType
{
  bitmap,
  vector,
  both
};

/*------------------------------- Constructors -------------------------------*/
  FaceNameCursor (FontType fontType = both,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());
virtual
 ~FaceNameCursor ( );

/*-------------------------------- Overrides ---------------------------------*/
virtual Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( ),
  isValid       ( ) const;

virtual void
  invalidate    ( );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned
  index,
  count;
IString
 *facenames;
friend class IFont;
};  //FaceNameCursor


class PointSizeCursor : public IVBase {
public:
/*------------------------------- Constructors -------------------------------*/
  PointSizeCursor(const char* facename,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());
virtual
 ~PointSizeCursor ( );

/*-------------------------------- Overrides ---------------------------------*/
virtual Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( ),
  isValid       ( ) const;

virtual void
  invalidate    ( );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IFont;

unsigned
  index,
  count;
long
 *pointsizes;
};  //PointSizeCursor

/*---------------------- Cursor Related Functions ----------------------------*/
static IString
  faceNameAt( const FaceNameCursor& faceNameCursor );

static long
  pointSizeAt( const PointSizeCursor& pointSizeCursor );


private:
/*--------------------------------- Private ----------------------------------*/
IFontPrivateData
 *ppd;

IFont
 &initialize     (const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &copyPrivate( );

IFont
 &makeFontMetrics(const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle(),
                  Boolean fUpdateCharSet = true ),
 &fontChanged    (),
 &mustUseVector  (Boolean fDoIt = true),
 &setFontFromDialog (IFontDialog& fontDlg,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());


friend void* __stdcall
  _IFontDlgProc( void*         hwnd,
                 unsigned long msg,
                 void*         mp1,
                 void*         mp2 );


}; //IFont

#pragma pack()

#endif /* _IFONT_ */
