#ifndef _IFONTHDR_
#define _IFONTHDR_
/*******************************************************************************
* FILE NAME: ifonthdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFontDialogHandler                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ievent.hpp>

class IFont;
class IFontDialog;
class IFontDialogHandlerData;

#pragma pack(4)

class IFontDialogHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*------------------------------ Constructors --------------------------------*/
  IFontDialogHandler();
virtual
  ~IFontDialogHandler();

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent(IEvent& event);

/*-------------------------- Font Dialog Dismissal ---------------------------*/
virtual Boolean
  modelessResults     (IFontDialog* endingDialog);

virtual Boolean
  modelessApply       (IFontDialog* modelessDialog,
                       IFont*       appliedFont );

private:
/*--------------------------------- Private ----------------------------------*/
IFontDialogHandlerData
 *fFontDialogHandlerData;
};

#pragma pack()

#endif /* IFONTHDR */
