#ifndef _IGARC_
#define _IGARC_
/*******************************************************************************
* FILE NAME: igarc.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGArc                                                                    *
*     IG3PointArc                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <ipoint.hpp>
#include <irect.hpp>


class IGraphicContext;

#pragma pack(4)

class IGArc : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGArc     ( const IRectangle& rectangle,
              double            startAngle,
              double            sweepAngle );

  IGArc     ( const IGArc&      arc        );

IGArc&
  operator= ( const IGArc&      arc        );

virtual
  ~IGArc    ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGArc
  &drawOn           ( IGraphicContext& graphicContext );

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGArc
  &setEnclosingRect     ( const IRectangle& rectangle );

virtual IRectangle
  enclosingRect         ( ) const;

/*----------------------- Start and Sweep Angles -----------------------------*/
virtual IGArc
  &setStartAngle    ( double startAngle ),
  &setSweepAngle    ( double sweepAngle );

virtual double
  startAngle        ( ) const,
  sweepAngle        ( ) const;

/*-------------------------------- Direction ---------------------------------*/
enum Direction {
  clockwise,
  counterclockwise
  };

virtual IGArc
  &setDirection     ( Direction direction = counterclockwise );

virtual Direction
  direction         ( ) const;

/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator==        ( const IGArc& arc ) const,
  operator!=        ( const IGArc& arc ) const;

private:
/*-------------------------------- Private -----------------------------------*/

IRectangle
  fRect;
double
  fStart,
  fSweep;
Direction
  fAd;
}; // IGArc

class IG3PointArc : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IG3PointArc( const IPoint& starting,
               const IPoint& intermediate,
               const IPoint& ending        );

  IG3PointArc( const IG3PointArc& arc      );

IG3PointArc&
  operator=  ( const IG3PointArc& arc      );

virtual
  ~IG3PointArc( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IG3PointArc
  &drawOn           ( IGraphicContext& graphicContext );

/*-------------------------------- Data Access -------------------------------*/
virtual IG3PointArc
  &setStartingPoint      ( const IPoint& point ),
  &setIntermediatePoint  ( const IPoint& point ),
  &setEndingPoint        ( const IPoint& point );

virtual IPoint
  startingPoint          ( ) const,
  intermediatePoint      ( ) const,
  endingPoint            ( ) const;

/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator== ( const IG3PointArc& arc ) const,
  operator!= ( const IG3PointArc& arc ) const;

private:
/*-------------------------------- Private -----------------------------------*/

IPoint
  fStart,
  fIntermediate,
  fEnd;
}; // IG3PointArc

#pragma pack()

#endif // _IGARC_
