#ifndef _IGBITMAP_
#define _IGBITMAP_
/*******************************************************************************
* FILE NAME: igbitmap.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGBitmap                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <ihandle.hpp>
#include <ipoint.hpp>
#include <icolor.hpp>


#pragma pack(4)

class IString;
class IGraphicContext;
class IResourceId;
class IGBitmapData;
struct _MOD;

class IGBitmap : public IGraphic {
typedef IGraphic
  Inherited;

public:

enum ImageFormat {
  Bitmap,
  GIF,
  PCX,
  TIFF,
  Targa,
  Amiga,
  XBM,
  PSEG
  };

/*------------------------------- Constructors -------------------------------*/
  IGBitmap  ( const IBitmapHandle&   bitmapHandle           );

  IGBitmap  ( unsigned long          bitmapIdentifier,
              IBase::Boolean         useColorData = false   );

  IGBitmap  ( const IResourceId&     resourceIdentifier,
              IBase::Boolean         useColorData = false   );

  IGBitmap  ( const IString&         imageFilename          );

  IGBitmap  ( const IString&         imageFilename,
              ImageFormat            imageFormat            );

  IGBitmap  ( const IGraphicContext& graphicContext,
              const IRectangle&      windowRectangle        );

  IGBitmap  ( const IGBitmap&        bitmap,
              const IRectangle&      rectangle,
              long                   rasterOperation = normal );

virtual
  ~IGBitmap ( );

/*----------------------- Common Raster Operations ---------------------------*/
static const long
  IC_IMPORTU black,
  IC_IMPORTU notSourceErase,
  IC_IMPORTU halftone,
  IC_IMPORTU invert,
  IC_IMPORTU sourceErase,
  IC_IMPORTU destInvert,
  IC_IMPORTU patternInvert,
  IC_IMPORTU sourceInvert,
  IC_IMPORTU sourceAnd,
  IC_IMPORTU mergePaint,
  IC_IMPORTU mergeCopy,
  IC_IMPORTU normal,
  IC_IMPORTU sourcePaint,
  IC_IMPORTU patternCopy,
  IC_IMPORTU patternPaint,
  IC_IMPORTU white;

/*------------------------------ Compress Mode -------------------------------*/
enum CompressMode {
  bitAnd,
  bitOr,
  ignore
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#ifndef __DIGRAPHS__
  ,
  or  = bitOr,
  and = bitAnd
#endif
#endif
  };

/*-------------------------------- Drawing -----------------------------------*/
virtual IGBitmap
  &drawOn              ( IGraphicContext& graphicContext            ),

  &drawOn              ( IGraphicContext& graphicContext,
                         long             rasterOperation           ),

  &drawOn              ( IGraphicContext& graphicContext,
                         const IPoint&    targetBottomLeft,
                         const IPoint&    targetTopRight,
                         const IPoint&    sourceBottomLeft,
                         const IPoint&    sourceTopRight,
                         long             rasterOperation = normal,
                         CompressMode     compressMode    = ignore  );

/*--------------------------- Writing To A File ------------------------------*/
virtual IGBitmap
  &writeToFile         ( const IString& imageFilename,
                         ImageFormat    imageFormat            );

virtual ImageFormat
  imageFormat          ( ) const;

/*--------------------------- Bitmap Positioning -----------------------------*/
virtual IGBitmap
  &moveTo              ( const IPoint& point   ),
  &sizeTo              ( const ISize&  newSize );

virtual ISize
  size                 ( ) const;
virtual IPoint
  position             ( ) const;

/*-------------------------- Modifying The Bitmap ----------------------------*/
virtual IGBitmap
  &reflectHorizontally ( ),
  &reflectVertically   ( ),
  &transposeXForY      ( ),
  &rotateBy90          ( ),
  &rotateBy180         ( ),
  &rotateBy270         ( );

/*------------------------------- View Option --------------------------------*/
enum ViewOption {
  raw,
  errorDiffused,
  halftoned
  };

virtual IGBitmap
  &setViewOption       ( ViewOption viewOption = raw );
virtual ViewOption
  viewOption           ( ) const;


/*--------------------------- Bitmap Transparency ----------------------------*/
virtual IGBitmap
  &setTransparentColor   ( const IColor& aColor ),
  &resetTransparentColor ( );

virtual IColor
  transparentColor       ( ) const;

virtual IBase::Boolean
  hasTransparentColor    ( ) const;

/*----------------------------- Bitmap Palette -------------------------------*/
unsigned long
  setPalette             ( unsigned long palette );

unsigned long
  palette                ( ) const;

/*-------------------------------- Accessors ---------------------------------*/
virtual IBitmapHandle
  handle               ( ) const;

virtual IPointerHandle
  asPointerHandle      ( ) const;

/*----------------------------- Bitmap Copying -------------------------------*/
static IBitmapHandle
  copy                   ( const IBitmapHandle& bitmapHandle );

protected:
/*---------------------------- Loading a Bitmap ------------------------------*/
static unsigned long
  loadBitmap           ( unsigned long        bitmapIdentifier,
                         const IModuleHandle& moduleHandle,
                         const ISize&         bitmapSize = ISize(0,0) ),
  tryToLoadBitmap      ( unsigned long        bitmapIdentifier,
                         const IModuleHandle& moduleHandle,
                         const ISize&         bitmapSize = ISize(0,0) );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IGBitmap    ( const IGBitmap& bitmap );
IGBitmap
 &operator=   ( const IGBitmap& bitmap );

/*--------------------------------- Private ----------------------------------*/
friend class IResourceLibrary;
static unsigned long
  copyBitmap(IGraphicContext&, unsigned long, const ISize&);
IGBitmap
  &modReflect  ( int (* _Optlink reflector)(_MOD*, _MOD*) ),
  &loadFromFile( const IString&    filename,
                 int               ft             ),
  &draw        ( IGraphicContext&, long, void *   );
static int
  ft( const ImageFormat& imageFormat );
void
  createMask();
IBitmapHandle
  fBitmap,
  fMask;
IPoint
  fPos;
IColor*
  fTransparent;
IBase::Boolean
  fCheckMaskNeeded;
ViewOption
  fVo;
ImageFormat
  fIf;
struct _MOD*
  fMod;

IGBitmapData
 *fGBitmapData;
};

#pragma pack()

#endif // _IGBITMAP_
