/*

MODEL.C  Work on the model used in GbmV2

*/

#ifndef MODEL_H
#define MODEL_H


#include "igbmstnd.hpp"
#include "igbm.hpp"

#define UNKNOWN_IMAGETYPE -1

/* These needs to encompass all the GBM errors, plus some extras */
typedef int MOD_ERR;
#define MOD_ERR_OK      ((MOD_ERR) 0)
#define MOD_ERR_MEM     ((MOD_ERR) 1)
#define MOD_ERR_OPEN    ((MOD_ERR) 2)
#define MOD_ERR_CREATE  ((MOD_ERR) 3)
#define MOD_ERR_SUPPORT ((MOD_ERR) 4)
#define MOD_ERR_HDC     ((MOD_ERR) 5)
#define MOD_ERR_HPS     ((MOD_ERR) 6)
#define MOD_ERR_HBITMAP ((MOD_ERR) 7)
#define MOD_ERR_HMF     ((MOD_ERR) 8)
#define MOD_ERR_CLIP    ((MOD_ERR) 9)
#define MOD_ERR_GBM(rc) ((MOD_ERR) 0x8000+(rc))

typedef struct _MOD
        {
        GBM    gbm;
        GBMRGB gbmrgb[0x100];
        BYTE*  pbData;
        long   bufSize;
        } MOD;

extern "C" MOD_ERR ModCreate(
        int w, int h, int bpp, GBMRGB gbmrgb[],
        MOD *modNew
        );

extern "C" MOD_ERR ModDelete(MOD *mod);

extern "C" MOD_ERR ModCopy(MOD *mod, MOD *modNew);

extern "C" MOD_ERR ModMove(MOD *mod, MOD *modNew);

extern "C" MOD_ERR ModCreateFromFile( CHAR *szFn,
                                      int *ft,
                                      CHAR *szOpt,
                                      MOD *modNew );

extern "C" MOD_ERR ModCreateFromHBitmap( MOD     *mod,
                                         HBITMAP  hbm,
                                         HPALETTE hpal );

extern "C" MOD_ERR ModWriteToFile( MOD *mod,
                                   int ft,
                                   CHAR *szFn,
                                   CHAR *szOpt );

extern "C" MOD_ERR ModExpandTo24Bpp(MOD *mod, MOD *mod24);

extern "C" MOD_ERR ModReflectHorz(MOD *mod, MOD *modNew);
extern "C" MOD_ERR ModReflectVert(MOD *mod, MOD *modNew);
extern "C" MOD_ERR ModTranspose  (MOD *mod, MOD *modNew);
extern "C" MOD_ERR ModRotate90   (MOD *mod, MOD *modNew);
extern "C" MOD_ERR ModRotate180  (MOD *mod, MOD *modNew);
extern "C" MOD_ERR ModRotate270  (MOD *mod, MOD *modNew);

extern "C" MOD_ERR ModExtractSubrectangle(
        MOD *mod,
        int x, int y, int w, int h,
        MOD *modNew
        );

extern MOD_ERR ModBlit(
        MOD *modDst, int dx, int dy,
        MOD *modSrc, int sx, int sy,
        int w, int h
        );

/*...scolour adjustment mappings:0:*/
#define CVT_I_TO_L      0
#define CVT_I_TO_P      1
#define CVT_L_TO_I      2
#define CVT_L_TO_P      3
#define CVT_P_TO_I      4
#define CVT_P_TO_L      5
/*...e*/

extern "C" MOD_ERR ModColourAdjust(
        MOD *mod,
        int map, double gama, double shelf,
        MOD *modNew
        );

/*...sbpp palette and algorithm mappings:0:*/
#define CVT_BW          0
#define CVT_VGA         1
#define CVT_8           2
#define CVT_4G          3
#define CVT_784         4
#define CVT_666         5
#define CVT_8G          6
#define CVT_TRIPEL      7
#define CVT_RGB         8
#define CVT_FREQ        9
#define CVT_MCUT        10

#define CVT_NEAREST     0
#define CVT_ERRDIFF     1
#define CVT_HALFTONE    2
/*...e*/

extern "C" MOD_ERR ModBppMap(
        MOD *mod,
        int iPal, int iAlg,
        int iKeepRed, int iKeepGreen, int iKeepBlue, int nCols,
        MOD *modNew
        );

extern "C" MOD_ERR ModResize(
        MOD *mod,
        int nw, int nh,
        MOD *modNew
        );

extern "C" MOD_ERR ModMakeHBITMAP(
        MOD *mod,
        HBITMAP *phbm,
        HPALETTE *phpal
        );

extern "C" BOOL ModMapVisual( MOD *mod, int viewOption, HBITMAP *phbm,
        LONG *plColorBg, LONG *plColorFg, HPALETTE *phpal
        );

extern "C" unsigned long ModError(MOD_ERR rc);

extern "C" HPALETTE CreateDIBPal(LPBITMAPINFO pbmi, BOOL bCoreHdr, int *iNumClr);

extern "C" HBITMAP LoadBitmapResource( HINSTANCE hInstance, LPSTR lpString, HPALETTE *lphPalette);

#endif
