#ifndef _IGBUNDLE_INL_
#define _IGBUNDLE_INL_ 0
/*******************************************************************************
* FILE NAME: igbundle.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in igbundle.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IGBUNDLE_
  #undef  _IGBUNDLE_INL_
  #define _IGBUNDLE_INL_ 1
  #include <igbundle.hpp>
#endif

#if _IGBUNDLE_INL_
  #define inline
#endif

inline IGraphicBundle& IGraphicBundle::setDrawOperation( DrawOperation drawOperation )
{
  fDrawOp = drawOperation;
  fMask  |= IGraphicBundle::drawOp;
  return *this;
}

inline IGraphicBundle::DrawOperation IGraphicBundle::drawOperation ( ) const
{
  return fDrawOp;
}

inline IGraphicBundle& IGraphicBundle::resetDrawOperation ( )
{
  fMask &= ~(unsigned long)IGraphicBundle::drawOp;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasDrawOperation ( )  const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::drawOp);
}

inline IGraphicBundle& IGraphicBundle::setPenColor( const IColor& penColor )
{
  fPen = penColor;
  fMask |= IGraphicBundle::pColor;
  return *this;
}

inline IColor IGraphicBundle::penColor ( ) const
{
  return fPen;
}

inline IGraphicBundle& IGraphicBundle::resetPenColor ( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pColor;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasPenColor ( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pColor);
}

inline IGraphicBundle& IGraphicBundle::setFillColor( const IColor& fillColor )
{
  fFill = fillColor;
  fMask |= IGraphicBundle::fColor;
  return *this;
}

inline IColor IGraphicBundle::fillColor ( ) const
{
  return fFill;
}

inline IGraphicBundle& IGraphicBundle::resetFillColor ( )
{
  fMask &= ~(unsigned long)IGraphicBundle::fColor;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasFillColor ( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::fColor);
}

inline IGraphicBundle& IGraphicBundle::setBackgroundColor(
                                                 const IColor& backgroundColor )
{
  fBack = backgroundColor;
  fMask |= IGraphicBundle::bColor;
  return *this;
}

inline IColor IGraphicBundle::backgroundColor ( ) const
{
  return fBack;
}

inline IGraphicBundle& IGraphicBundle::resetBackgroundColor ( )
{
  fMask &= ~(unsigned long)IGraphicBundle::bColor;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasBackgroundColor ( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::bColor);
}

inline IGraphicBundle& IGraphicBundle::setPenWidth( unsigned long width )
{
  fWidth = width;
  fMask |= IGraphicBundle::pWidth;
  return *this;
}


inline unsigned long IGraphicBundle::penWidth( ) const
{
  return fWidth;
}

inline IGraphicBundle& IGraphicBundle::resetPenWidth( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pWidth;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasPenWidth( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pWidth);
}

inline IGraphicBundle& IGraphicBundle::setMixMode( MixMode mixMode )
{
  fMask |= IGraphicBundle::pMix;
  fPmix = mixMode;
  return *this;
}

inline IGraphicBundle::MixMode IGraphicBundle::mixMode( ) const
{
  return fPmix;
}

inline IGraphicBundle& IGraphicBundle::resetMixMode( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pMix;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasMixMode( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pMix);
}

inline IGraphicBundle& IGraphicBundle::setBackgroundMixMode(
                                           BackgroundMixMode backgroundMixMode )
{
  fMask |= IGraphicBundle::bMix;
  fBmix = backgroundMixMode;
  return *this;
}

inline IGraphicBundle::BackgroundMixMode IGraphicBundle::backgroundMixMode( ) const
{
  return fBmix;
}

inline IGraphicBundle& IGraphicBundle::resetBackgroundMixMode( )
{
  fMask &= ~(unsigned long)IGraphicBundle::bMix;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasBackgroundMixMode( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::bMix);
}

inline IGraphicBundle& IGraphicBundle::setPenType( PenType penType )
{
  fMask |= IGraphicBundle::pType;
  fPtype = penType;
  return *this;
}

inline IGraphicBundle::PenType IGraphicBundle::penType( ) const
{
  return fPtype;
}

inline IGraphicBundle& IGraphicBundle::resetPenType( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pType;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasPenType( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pType);
}

inline IGraphicBundle& IGraphicBundle::setPenEndingStyle( PenEndingStyle penEndingStyle )
{
  fMask |= IGraphicBundle::pEnd;
  fPend = penEndingStyle;
  return *this;
}

inline IGraphicBundle::PenEndingStyle IGraphicBundle::penEndingStyle( ) const
{
  return fPend;
}

inline IGraphicBundle& IGraphicBundle::resetPenEndingStyle( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pEnd;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasPenEndingStyle( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pEnd);
}

inline IGraphicBundle& IGraphicBundle::setPenJoiningStyle(
                                               PenJoiningStyle penJoiningStyle )
{
  fMask |= IGraphicBundle::pJoin;
  fPjoin = penJoiningStyle;
  return *this;
}

inline IGraphicBundle::PenJoiningStyle IGraphicBundle::penJoiningStyle( ) const
{
  return fPjoin;
}

inline IGraphicBundle& IGraphicBundle::resetPenJoiningStyle( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pJoin;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasPenJoiningStyle( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pJoin);
}

inline IGraphicBundle& IGraphicBundle::setPenPattern( unsigned long penPattern )
{
  fMask |= IGraphicBundle::pPat;
  fPpat = penPattern;
  return *this;
}

inline unsigned long IGraphicBundle::penPattern( ) const
{
  return fPpat;
}

inline IGraphicBundle& IGraphicBundle::resetPenPattern( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pPat;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasPenPattern( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pPat);
}

inline IGraphicBundle& IGraphicBundle::setFillPattern( unsigned long fillPattern )
{
  fMask |= IGraphicBundle::fPat;
  fFpat = fillPattern;
  return *this;
}

inline unsigned long IGraphicBundle::fillPattern( ) const
{
  return fFpat;
}

inline IGraphicBundle& IGraphicBundle::resetFillPattern( )
{
  fMask &= ~(unsigned long)IGraphicBundle::fPat;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasFillPattern( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::fPat);
}

inline IGraphicBundle& IGraphicBundle::setPatternOrigin( const IPoint& pt )
{
  fOrg = pt;
  fMask |= IGraphicBundle::pOrg;
  return *this;
}

inline IPoint IGraphicBundle::patternOrigin( ) const
{
  return fOrg;
}

inline IGraphicBundle& IGraphicBundle::resetPatternOrigin( )
{
  fMask &= ~(unsigned long)IGraphicBundle::pOrg;
  return *this;
}

inline IBase::Boolean IGraphicBundle::hasPatternOrigin( ) const
{
  return (IBase::Boolean)(fMask & IGraphicBundle::pOrg);
}


#endif // _IGBUNDLE_INL_
