#ifndef _IGELIPSE_
#define _IGELIPSE_
/*******************************************************************************
* FILE NAME: igelipse.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGEllipse                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <irect.hpp>


#pragma pack(4)

class IGraphicContext;

class IGEllipse : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGEllipse  ( const IRectangle& rectangle );

  IGEllipse  ( const IPoint&     point,
               unsigned long     radius    );

  IGEllipse  ( const IPoint&     point,
               unsigned long     xRadius,
               unsigned long     yRadius   );

  IGEllipse  ( const IGEllipse&  ellipse   );

IGEllipse
  &operator= ( const IGEllipse&  ellipse   );

virtual
  ~IGEllipse ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGEllipse
  &drawOn            ( IGraphicContext& graphicContext );

/*-------------------------- Enclosing Rectangle -----------------------------*/
virtual IGEllipse
  &setEnclosingRect  ( const IRectangle& rectangle );

virtual IRectangle
  enclosingRect      ( ) const;

/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator== ( const IGEllipse& ellipse ) const,
  operator!= ( const IGEllipse& ellipse ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IRectangle
  fRect;
}; // IGEllipse

#pragma pack()

#endif // _IGELIPSE_
