#ifndef _IGLINE_
#define _IGLINE_
/*******************************************************************************
* FILE NAME: igline.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGLine                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <ipoint.hpp>


class IGraphicContext;
class IGraphicBundle;

#pragma pack(4)

class IGLine : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGLine    ( const IPoint& startingPoint,
              const IPoint& endingPoint    );

  IGLine    ( const IGLine& line           );

IGLine&
  operator= ( const IGLine& line           );

virtual
  ~IGLine ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGLine
  &drawOn          ( IGraphicContext& graphicContext );

/*------------------------------ Data Access ---------------------------------*/
virtual IGLine
  &setStartingPoint ( const IPoint& point ),
  &setEndingPoint   ( const IPoint& point );

virtual IPoint
  startingPoint     ( ) const,
  endingPoint       ( ) const,
  centerPoint       ( ) const;

double
  slope             ( ) const;

/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator== ( const IGLine& line ) const,
  operator!= ( const IGLine& line ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IPoint
  fStart,
  fEnd;
}; // IGLine

#pragma pack()

#endif // _IGLINE_
