#ifndef _IGPYLINE_
#define _IGPYLINE_
/*******************************************************************************
* FILE NAME: IPLYLINE.HPP                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGPolyline                                                               *
*     IGPolygon                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <iptarray.hpp>


#pragma pack(4)

class IGraphicContext;

class IGPolyline : public IGraphic {
typedef IGraphic
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGPolyline  ( const IPointArray& pointArray );

  IGPolyline  ( const IGPolyline&  polyline   );

IGPolyline
  &operator=  ( const IGPolyline&  polyline   );

virtual
  ~IGPolyline ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGPolyline
  &drawOn             ( IGraphicContext& graphicContext );

/*------------------------------- Data Points --------------------------------*/
virtual unsigned long
  numberOfPoints      ( ) const;

const IPointArray
  &pointArray         ( ) const;
const IPoint
  &point              ( unsigned long      index      ) const;

virtual IGPolyline
  &setPoints          ( const IPointArray& pointArray ),
  &setPoint           ( unsigned long      index,
                        const IPoint&      point      ),
  &insertPoint        ( unsigned long      index,
                        const IPoint&      point      ),
  &addPoint           ( const IPoint&      point      ),
  &removePoint        ( unsigned long      index      ),
  &reversePoints      ( );

/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator== ( const IGPolyline& polyline ) const,
  operator!= ( const IGPolyline& polyline ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IPointArray
  fPtArray;
}; // IGPolyline


class IGPolygon : public IGPolyline {
typedef IGPolyline
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGPolygon  ( const IPointArray& pointArray );

  IGPolygon  ( const IGPolygon&   polygon    );

IGPolygon&
  operator=  ( const IGPolygon&   polygon    );

virtual
  ~IGPolygon ( );

/*-------------------------------- Drawing -----------------------------------*/
virtual IGPolygon
  &drawOn           ( IGraphicContext& graphicContext );

/*--------------------------------- Fill Mode --------------------------------*/
enum FillMode {
  alternate,
  winding
  };

virtual IGPolygon
  &setFillMode      ( FillMode fillmode );

virtual FillMode
  fillMode          ( ) const;

/*-------------------------------- Comparison --------------------------------*/
Boolean
  operator== ( const IGPolygon& polygon ) const,
  operator!= ( const IGPolygon& polygon ) const;

private:
/*-------------------------------- Private -----------------------------------*/
FillMode
  fFm;
}; // IGPolygon

#pragma pack()
#endif // _IGPYLINE_
