#ifndef _IGSTRING_
#define _IGSTRING_
/*******************************************************************************
* FILE NAME: igstring.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IGString                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <igraphic.hpp>
#include <istring.hpp>
#include <ipoint.hpp>


#pragma pack(4)

class IResourceId;
class IFont;
class IGraphicContext;

class IGString : public IGraphic {
typedef IGraphic
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IGString   ( const IString&  string,
               const IPoint&   point = IPoint() );

  IGString   ( const IString&  string,
               const IPoint&   point,
               const IFont&    font             );

  IGString   ( const IGString& graphicString    );

IGString
  &operator= ( const IGString& graphicString    );

virtual
  ~IGString  ( );

/*--------------------------------- Drawing ----------------------------------*/
virtual IGString
  &drawOn            ( IGraphicContext& graphicContext );

/*---------------------------------- Text ------------------------------------*/
virtual IGString
  &setText           ( const char*        text ),
  &setText           ( const IResourceId& text );

virtual IString
  text               ( ) const;

/*---------------------------------- Font ------------------------------------*/
virtual IGString
  &setFont           ( const IFont& font );

virtual IFont
  font               ( ) const;

virtual IBase::Boolean
  hasFont            ( ) const;

virtual IGString
  &removeFont        ( );

/*----------------------------- Text Positioning -----------------------------*/
virtual IGString
  &moveTo            ( const IPoint& point );

virtual IPoint
  position           ( ) const;

/*---------------------------- Clipping Rectangle ----------------------------*/
virtual IGString
  &setClippingRect   ( const IRectangle& rectangle );

virtual IRectangle
  clippingRect       ( ) const;

virtual IGString
  &resetClippingRect ( );

virtual IBase::Boolean
  isClippingRectSet  ( ) const;


/*-------------------------------- Comparison --------------------------------*/
IBase::Boolean
  operator== ( const IGString& graphicString ) const,
  operator!= ( const IGString& graphicString ) const;

private:
/*-------------------------------- Private -----------------------------------*/
IGString();
IString
  fString;
IPoint
  fLocation;
IFont
 *fFont;
IRectangle
 *fClip;
}; // IGString

#pragma pack()

#endif // _IGSTRING_
