#ifndef _IGUIBNDL_INL_
#define _IGUIBNDL_INL_ 0
/*******************************************************************************
* FILE NAME: iguibndl.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in iguibndl.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IGUIBNDL_
  #undef  _IGUIBNDL_INL_
  #define _IGUIBNDL_INL_ 1
  #include <iguibndl.hpp>
#endif

#if _IGUIBNDL_INL_
  #define inline
#endif


//===============================================================================
//
// inline members of class IGUIBundle
//

inline
IComponent&
IGUIBundle::component() const
{
    return *fpComponent;
}

inline
IView&
IGUIBundle::view() const
{
    return *fpView;
}

inline
IFrameWindow&
IGUIBundle::inPlaceFrame() const
{
    return *fpInPlaceFrame;
}

inline
IView&
IGUIBundle::inPlaceView() const
{
    return *fpInPlaceView;
}

inline
void
IGUIBundle::useInPlaceWindows( Boolean use )
{
    fbUsingInPlace = use;
}

#endif /* _IGUIBNDL_INL_ */

