#ifndef _IHANDLE_
#define _IHANDLE_
/*******************************************************************************
* FILE NAME: ihandle.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IWindowHandle                                                            *
*     IAnchorBlockHandle                                                       *
*     IModuleHandle                                                            *
*     IPointerHandle                                                           *
*     IStringHandle                                                            *
*     IPresSpaceHandle                                                         *
*     IBitmapHandle                                                            *
*     IProfileHandle                                                           *
*     IMessageQueueHandle                                                      *
*     IAccelTblHandle                                                          *
*     ISystemPointerHandle                                                     *
*     ISystemBitmapHandle                                                      *
*     IThreadId                                                                *
*     IProcessId                                                               *
*     IEnumHandle                                                              *
*     IRegionHandle                                                            *
*     IContextHandle                                                           *
*     IDisplayHandle                                                           *
*     IMenuHandle                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ibhandle.hpp>
#include <ievtdata.hpp>

struct _WidgetRec;
struct _XtAppStruct;
struct _XGC;
struct _XDisplay;
struct _XrmHashBucketRec;

#pragma pack(4)

class IWindowHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IWindowHandle ( Value hwnd = 0 );

/*-------------------------------- Operators ---------------------------------*/

/*--------------------------------- Testing ----------------------------------*/
Boolean
  isValid ( ) const;

/*----------------------- Sending and Posting Events -------------------------*/
enum BroadcastTo {
  descendants,
  frames,
  frameDescendants
  };

IEventResult
  sendEvent  ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ) const;

void
  sendEvents ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul,
               BroadcastTo             value = descendants ) const;

void
  postEvent  ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ) const,

  postEvents ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul,
               BroadcastTo             value = descendants ) const;

}; // class IWindowHandle

class IAnchorBlockHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IAnchorBlockHandle ( Value hab = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IAnchorBlockHandle


class IModuleHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IModuleHandle ( Value hmod = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IModuleHandle



class IPointerHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPointerHandle ( Value                 hpointer = 0 );
  IPointerHandle ( const IPointerHandle& aHandle );
 ~IPointerHandle ( );

IPointerHandle
 &operator =     ( const IPointerHandle& aHandle );

/*-------------------------------- Operators ---------------------------------*/

}; // class IPointerHandle

class ISystemPointerHandle : public IPointerHandle {
typedef IPointerHandle
  Inherited;
public:
/*------------------------ System Pointer Identifiers ------------------------*/
enum Identifier {
  arrow,
  text,
  wait,
  move,
  sizeNWSE,
  sizeNESW,
  sizeHorizontal,
  sizeVertical,
  standardApplication,
  information,
  question,
  error,
  warning,
  illegalOperation,
  singleFile,
  multipleFile,
  folder,
  program,
  dragFade
  };

/*------------------------------- Constructors -------------------------------*/
  ISystemPointerHandle ( Identifier pointerId,
                         Boolean    makeCopy = false );
 ~ISystemPointerHandle ( );

}; // class ISysPointerHandle

class IStringHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IStringHandle ( Value hstr = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IStringHandle


class IPresSpaceHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPresSpaceHandle ( Value hps = 0 );
}; // class IPresSpaceHandle

class IBitmapHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IBitmapHandle ( Value value = 0 );
  IBitmapHandle ( const IBitmapHandle& aHandle );
 ~IBitmapHandle ( );

IBitmapHandle
 &operator =    ( const IBitmapHandle& aHandle );

/*-------------------------------- Operators ---------------------------------*/

}; // class IBitmapHandle

class ISystemBitmapHandle : public IBitmapHandle {
typedef IBitmapHandle
  Inherited;
public:
/*------------------------- System Bitmap Identifiers ------------------------*/
enum Identifier {
  systemMenu,
  systemMenuPressed,
  scrollBarUpArrow,
  scrollBarUpArrowPressed,
  scrollBarUpArrowDisabled,
  scrollBarDownArrow,
  scrollBarDownArrowPressed,
  scrollBarDownArrowDisabled,
  scrollBarRightArrow,
  scrollBarRightArrowPressed,
  scrollBarRightArrowDisabled,
  scrollBarLeftArrow,
  scrollBarLeftArrowPressed,
  scrollBarLeftArrowDisabled,
  menuCheckMark,
  menuAttached,
  checkBoxCheck,
  comboBoxDownArrow,
  pushButtonCorners,
  minimizeButton,
  minimizeButtonPressed,
  maximizeButton,
  maximizeButtonPressed,
  restoreButton,
  restoreButtonPressed,
  childSystemMenu,
  childSystemMenuPressed,
  drive,
  file,
  folder,
  collapsedTree,
  expandedTree,
  program,
  sizeBox,
  smallSystemMenu
  };

/*------------------------------- Constructors -------------------------------*/
  ISystemBitmapHandle ( Identifier bitmapId );
 ~ISystemBitmapHandle ( );

}; // class ISystemBitmapHandle

class IProfileHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IProfileHandle ( Value hini = 0 );

/*------------------------------- Operators ----------------------------------*/
}; // class IProfileHandle

class IMessageQueueHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMessageQueueHandle ( Value hmq = 0 );

/*-------------------------------- Operators ---------------------------------*/

/*-------------------------------- Post Event --------------------------------*/
void
  postEvent  ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ) const;
static void
  postEvent  ( const IMessageQueueHandle&    handle,
               unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ),

  postEvents ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul );
}; // class IMessageQueueHandle

class IAccelTblHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IAccelTblHandle ( Value haccel = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IAccelTblHandle

class IThreadId : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IThreadId ( Value tid = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IThreadID

class IThreadHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IThreadHandle ( Value thread = 0 );

/*-------------------------- Thread Handle Specifics -------------------------*/
static const IThreadHandle
  IC_IMPORTU noHandle;

}; // class IThreadHandle

class IProcessId : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IProcessId ( Value pid = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IProcessId

class IEnumHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IEnumHandle ( Value henum = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IEnumHandle

class IRegionHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IRegionHandle ( Value hregion = 0 );

/*-------------------------------- Operators ---------------------------------*/

}; // class IEnumHandle



class IMenuHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuHandle ( Value hmenu = 0 );

}; // class IMenuHandle

#pragma pack()

  #include <ihandle.inl>

#endif // _IHANDLE_
