#ifndef _IHANDLE_INL_
#define _IHANDLE_INL_ 0
/*******************************************************************************
* FILE NAME: ihandle.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ihandle.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IHANDLE_
  #undef  _IHANDLE_INL_
  #define _IHANDLE_INL_ 1
  #include <ihandle.hpp>
#endif

#if _IHANDLE_INL_
  #define inline
#endif



inline IWindowHandle :: IWindowHandle ( Value value )
  : IHandle( value )
  {
  }

inline IAnchorBlockHandle :: IAnchorBlockHandle ( Value value )
  : IHandle( value )
  {
  }

inline IModuleHandle :: IModuleHandle ( Value value )
  : IHandle( value )
  {
  }

inline IStringHandle :: IStringHandle ( Value value )
  : IHandle( value )
  {
  }


inline IPresSpaceHandle :: IPresSpaceHandle ( Value value )
  : IHandle( value )
  {
  }


inline IProfileHandle :: IProfileHandle ( Value value )
  : IHandle( value )
  {
  }

inline IMessageQueueHandle :: IMessageQueueHandle ( Value value )
  : IHandle( value )
  {
  }

inline IAccelTblHandle :: IAccelTblHandle ( Value value )
  : IHandle( value )
  {
  }

inline IProcessId :: IProcessId ( Value value )
  : IHandle( value )
  {
  }

inline IThreadId :: IThreadId ( Value value )
  : IHandle( value )
  {
  }

inline IThreadHandle :: IThreadHandle ( Value value )
  : IHandle( value )
  {
  }

inline IEnumHandle :: IEnumHandle ( Value value )
  : IHandle( value )
  {
  }

inline IRegionHandle :: IRegionHandle ( Value value )
  : IHandle( value )
  {
  }


inline IMenuHandle :: IMenuHandle ( Value value )
  : IMenuHandle::Inherited( value )
  {
  }

#endif // _IHANDLE_INL_
